/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking;

import java.util.Optional;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.phase.general.GeneralPhase;
import org.spongepowered.common.util.PrettyPrinter;

public final class UnwindingPhaseContext
extends PhaseContext<UnwindingPhaseContext> {
    private final IPhaseState<@NonNull ?> unwindingState;
    private final PhaseContext<@NonNull ?> unwindingContext;

    @Override
    protected void reset() {
        super.reset();
    }

    static @Nullable UnwindingPhaseContext unwind(PhaseContext<@NonNull ?> context, boolean hasCaptures) {
        if (!context.requiresPost() || !hasCaptures) {
            return null;
        }
        return (UnwindingPhaseContext)((UnwindingPhaseContext)new UnwindingPhaseContext(context).source(context.getSource())).buildAndSwitch();
    }

    private UnwindingPhaseContext(PhaseContext<@NonNull ?> unwindingContext) {
        super(GeneralPhase.Post.UNWINDING, unwindingContext.createdTracker);
        this.unwindingState = unwindingContext.state;
        this.unwindingContext = unwindingContext;
        this.setBlockEvents(unwindingContext.doesBlockEventTracking());
    }

    @Override
    public Optional<UUID> getCreator() {
        return this.unwindingContext.getCreator();
    }

    @Override
    public Optional<UUID> getNotifier() {
        return this.unwindingContext.getNotifier();
    }

    public <T extends PhaseContext<T>> T getUnwindingContext() {
        return (T)this.unwindingContext;
    }

    IPhaseState<?> getUnwindingState() {
        return this.unwindingState;
    }

    @Override
    public PrettyPrinter printCustom(PrettyPrinter printer, int indent) {
        String s = String.format("%1$" + indent + "s", "");
        super.printCustom(printer, indent).add(s + "- %s: %s", "UnwindingState", this.unwindingState).add(s + "- %s: %s", "UnwindingContext", this.unwindingContext);
        this.unwindingContext.printCustom(printer, indent * 2);
        return printer;
    }
}

