/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context.transaction.block;

import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.BiConsumer;
import net.minecraft.world.level.TickNextTickData;
import net.minecraft.world.level.block.state.BlockState;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.block.ChangeBlockEvent;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.bridge.world.level.TickNextTickDataBridge;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.context.transaction.GameTransaction;
import org.spongepowered.common.event.tracking.context.transaction.block.BlockEventBasedTransaction;
import org.spongepowered.common.util.PrettyPrinter;

public class ScheduleUpdateTransaction
extends BlockEventBasedTransaction {
    private final TickNextTickData<?> data;
    private final SpongeBlockSnapshot original;

    public ScheduleUpdateTransaction(SpongeBlockSnapshot original, TickNextTickData<?> data) {
        super(original.getBlockPos(), (BlockState)original.state(), original.world());
        this.data = data;
        this.original = original;
    }

    @Override
    protected SpongeBlockSnapshot getResultingSnapshot() {
        return this.getOriginalSnapshot();
    }

    @Override
    protected SpongeBlockSnapshot getOriginalSnapshot() {
        return this.original;
    }

    @Override
    public Optional<BiConsumer<PhaseContext<@NonNull ?>, CauseStackManager.StackFrame>> getFrameMutator(@Nullable GameTransaction<@NonNull ?> parent) {
        return Optional.empty();
    }

    @Override
    public void addToPrinter(PrettyPrinter printer) {
        printer.add("AddBlockEvent").add(" %s : %s", "Original Block", this.original).add(" %s : %s", "Original State", this.originalState).add(" %s : %s", "EventData", this.data);
    }

    @Override
    public void restore(PhaseContext<?> context, ChangeBlockEvent.All event) {
        ((TickNextTickDataBridge)this.data).bridge$cancelForcibly();
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", ScheduleUpdateTransaction.class.getSimpleName() + "[", "]").add("scheduledUpdate=" + this.data).add("original=" + this.original).add("affectedPosition=" + this.affectedPosition).add("originalState=" + this.originalState).add("worldKey=" + this.worldKey).add("cancelled=" + this.cancelled).toString();
    }
}

