/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context.transaction.effect;

import net.minecraft.core.Registry;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.logging.log4j.util.Supplier;
import org.spongepowered.common.accessor.server.level.ServerLevelAccessor;
import org.spongepowered.common.accessor.world.level.LevelAccessor;
import org.spongepowered.common.event.tracking.context.transaction.effect.EffectResult;
import org.spongepowered.common.event.tracking.context.transaction.effect.ProcessingSideEffect;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.BlockPipeline;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.PipelineCursor;
import org.spongepowered.common.world.SpongeBlockChangeFlag;

public final class AddTileEntityToWorldWhileProcessingEffect
implements ProcessingSideEffect {
    public static AddTileEntityToWorldWhileProcessingEffect getInstance() {
        return Holder.INSTANCE;
    }

    AddTileEntityToWorldWhileProcessingEffect() {
    }

    @Override
    public EffectResult processSideEffect(BlockPipeline pipeline, PipelineCursor oldState, BlockState newState, SpongeBlockChangeFlag flag, int limit) {
        ServerLevel serverWorld = pipeline.getServerWorld();
        BlockEntity tileEntity = oldState.tileEntity;
        if (tileEntity == null) {
            return EffectResult.NULL_RETURN;
        }
        if (((LevelAccessor)serverWorld).accessor$updatingBlockEntities()) {
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = () -> Registry.BLOCK_ENTITY_TYPE.getKey((Object)tileEntity.getType());
            supplierArray[1] = () -> ((BlockEntity)tileEntity).getBlockPos();
            ServerLevelAccessor.accessor$LOGGER().error("Adding block entity while ticking: {} @ {}", supplierArray);
            boolean add = ((LevelAccessor)serverWorld).accessor$pendingBlockEntities().add(tileEntity);
            if (add) {
                return new EffectResult(oldState.state, true);
            }
            return EffectResult.NULL_RETURN;
        }
        return EffectResult.NULL_PASS;
    }

    private static final class Holder {
        static final AddTileEntityToWorldWhileProcessingEffect INSTANCE = new AddTileEntityToWorldWhileProcessingEffect();

        private Holder() {
        }
    }
}

