/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context.transaction.world;

import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.event.Cancellable;
import org.spongepowered.api.event.Event;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.context.transaction.GameTransaction;
import org.spongepowered.common.event.tracking.context.transaction.type.TransactionType;

public abstract class WorldBasedTransaction<E extends Event & Cancellable>
extends GameTransaction<E> {
    protected final ResourceKey worldKey;

    protected WorldBasedTransaction(TransactionType<? extends E> transactionType, ResourceKey worldKey) {
        super(transactionType);
        this.worldKey = worldKey;
    }

    @Override
    public final Optional<ResourceKey> worldKey() {
        return Optional.of(this.worldKey);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean shouldBuildEventAndRestartBatch(GameTransaction<@NonNull ?> pointer, PhaseContext<@NonNull ?> context) {
        if (super.shouldBuildEventAndRestartBatch(pointer, context)) return true;
        if (pointer.worldKey().map(this.worldKey::equals).orElse(false) != false) return false;
        return true;
    }
}

