/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.packet;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.PacketListener;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.network.protocol.game.ServerboundClientCommandPacket;
import net.minecraft.network.protocol.game.ServerboundClientInformationPacket;
import net.minecraft.network.protocol.game.ServerboundCustomPayloadPacket;
import net.minecraft.network.protocol.game.ServerboundMovePlayerPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.animal.horse.AbstractChestedHorse;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.api.item.inventory.transaction.SlotTransaction;
import org.spongepowered.common.accessor.entity.passive.AbstractChestedHorseEntityAccessor;
import org.spongepowered.common.accessor.network.protocol.game.ServerboundMovePlayerPacketAccessor;
import org.spongepowered.common.accessor.world.entity.EntityAccessor;
import org.spongepowered.common.accessor.world.entity.animal.PigAccessor;
import org.spongepowered.common.accessor.world.entity.animal.SheepAccessor;
import org.spongepowered.common.accessor.world.entity.animal.WolfAccessor;
import org.spongepowered.common.accessor.world.inventory.SlotAccessor;
import org.spongepowered.common.bridge.world.level.block.TrackableBlockBridge;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.block.BlockPhase;
import org.spongepowered.common.event.tracking.phase.packet.PacketContext;
import org.spongepowered.common.event.tracking.phase.packet.PacketPhase;
import org.spongepowered.common.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.inventory.adapter.impl.slots.SlotAdapter;
import org.spongepowered.common.item.util.ItemStackUtil;

public final class PacketPhaseUtil {
    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static void handleSlotRestore(@Nullable Player player, @Nullable AbstractContainerMenu containerMenu, List<SlotTransaction> slotTransactions, boolean eventCancelled) {
        try (@NonNull P ignored = ((PhaseContext)BlockPhase.State.RESTORING_BLOCKS.createPhaseContext(PhaseTracker.SERVER)).buildAndSwitch();){
            boolean restoredAny = false;
            for (SlotTransaction slotTransaction : slotTransactions) {
                ItemStackSnapshot snapshot;
                if (!slotTransaction.custom().isPresent() && slotTransaction.isValid() && !eventCancelled) continue;
                restoredAny = true;
                Slot slot = slotTransaction.slot();
                ItemStackSnapshot itemStackSnapshot = snapshot = eventCancelled || !slotTransaction.isValid() ? (ItemStackSnapshot)slotTransaction.original() : (ItemStackSnapshot)slotTransaction.custom().get();
                if (containerMenu == null || slot.viewedSlot() == slot) {
                    slot.set(snapshot.createStack());
                    continue;
                }
                int slotNumber = ((SlotAdapter)slot).getOrdinal();
                net.minecraft.world.inventory.Slot nmsSlot = containerMenu.getSlot(slotNumber);
                if (nmsSlot == null) continue;
                nmsSlot.set(ItemStackUtil.fromSnapshotToNative(snapshot));
            }
            if (restoredAny && player instanceof net.minecraft.server.level.ServerPlayer) {
                if (containerMenu != null) {
                    containerMenu.broadcastChanges();
                    if (player.containerMenu == containerMenu) {
                        ((net.minecraft.server.level.ServerPlayer)player).refreshContainer(containerMenu);
                    }
                } else {
                    player.inventoryMenu.broadcastChanges();
                }
            }
        }
    }

    public static void handleCursorRestore(Player player, Transaction<ItemStackSnapshot> cursorTransaction) {
        ItemStackSnapshot cursorSnap;
        if (!cursorTransaction.isValid()) {
            cursorSnap = cursorTransaction.original();
        } else if (cursorTransaction.custom().isPresent()) {
            cursorSnap = cursorTransaction.finalReplacement();
        } else {
            return;
        }
        ItemStack cursor = ItemStackUtil.fromSnapshotToNative(cursorSnap);
        player.inventory.setCarried(cursor);
        if (player instanceof net.minecraft.server.level.ServerPlayer) {
            ((net.minecraft.server.level.ServerPlayer)player).connection.send((Packet)new ClientboundContainerSetSlotPacket(-1, -1, cursor));
        }
    }

    public static void handleCustomCursor(Player player, ItemStackSnapshot customCursor) {
        ItemStack cursor = ItemStackUtil.fromSnapshotToNative(customCursor);
        player.inventory.setCarried(cursor);
        if (player instanceof net.minecraft.server.level.ServerPlayer) {
            ((net.minecraft.server.level.ServerPlayer)player).connection.send((Packet)new ClientboundContainerSetSlotPacket(-1, -1, cursor));
        }
    }

    public static void validateCapturedTransactions(int slotId, AbstractContainerMenu containerMenu, List<SlotTransaction> capturedTransactions) {
        net.minecraft.world.inventory.Slot slot;
        if (capturedTransactions.size() == 0 && slotId >= 0 && slotId < containerMenu.slots.size() && (slot = containerMenu.getSlot(slotId)) != null) {
            ItemStackSnapshot snapshot = ItemStackUtil.snapshotOf(slot.getItem());
            SlotTransaction slotTransaction = new SlotTransaction(((InventoryAdapter)containerMenu).inventoryAdapter$getSlot(slotId).get(), snapshot, snapshot);
            capturedTransactions.add(slotTransaction);
        }
    }

    public static void handlePlayerSlotRestore(net.minecraft.server.level.ServerPlayer player, ItemStack itemStack, InteractionHand hand) {
        if (itemStack.isEmpty()) {
            return;
        }
        player.ignoreSlotUpdateHack = false;
        int slotId = 0;
        if (hand == InteractionHand.OFF_HAND) {
            player.inventory.offhand.set(0, (Object)itemStack);
            slotId = player.inventory.items.size() + Inventory.getSelectionSize();
        } else {
            player.inventory.items.set(player.inventory.selected, (Object)itemStack);
            for (net.minecraft.world.inventory.Slot containerSlot : player.containerMenu.slots) {
                if (containerSlot.container != player.inventory || ((SlotAccessor)containerSlot).accessor$slot() != player.inventory.selected) continue;
                slotId = containerSlot.index;
                break;
            }
        }
        player.containerMenu.broadcastChanges();
        player.ignoreSlotUpdateHack = false;
        player.connection.send((Packet)new ClientboundContainerSetSlotPacket(player.containerMenu.containerId, slotId, itemStack));
    }

    public static boolean allTransactionsInvalid(List<SlotTransaction> slotTransactions) {
        if (slotTransactions.size() == 0) {
            return false;
        }
        for (SlotTransaction slotTransaction : slotTransactions) {
            if (!slotTransaction.isValid()) continue;
            return false;
        }
        return true;
    }

    public static void onProcessPacket(Packet packetIn, PacketListener netHandler) {
        if (netHandler instanceof ServerGamePacketListenerImpl) {
            net.minecraft.server.level.ServerPlayer packetPlayer = ((ServerGamePacketListenerImpl)netHandler).player;
            if (!(packetPlayer.isAlive() || packetIn instanceof ServerboundCustomPayloadPacket || packetIn instanceof ServerboundClientCommandPacket && ((ServerboundClientCommandPacket)packetIn).getAction() == ServerboundClientCommandPacket.Action.PERFORM_RESPAWN)) {
                return;
            }
            try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
                boolean ignoreMovementCapture;
                frame.pushCause(packetPlayer);
                if (packetIn instanceof ServerboundMovePlayerPacket) {
                    ServerboundMovePlayerPacket movingPacket = (ServerboundMovePlayerPacket)packetIn;
                    ignoreMovementCapture = movingPacket instanceof ServerboundMovePlayerPacket.Rot ? true : packetPlayer.getX() == ((ServerboundMovePlayerPacketAccessor)movingPacket).accessor$x() && packetPlayer.getY() == ((ServerboundMovePlayerPacketAccessor)movingPacket).accessor$y() && packetPlayer.getZ() == ((ServerboundMovePlayerPacketAccessor)movingPacket).accessor$z();
                    if (ignoreMovementCapture) {
                        AABB boundingBox = packetPlayer.getBoundingBox();
                        BlockPos min = new BlockPos(boundingBox.minX + 0.001, boundingBox.minY + 0.001, boundingBox.minZ + 0.001);
                        BlockPos max = new BlockPos(boundingBox.maxX - 0.001, boundingBox.maxY - 0.001, boundingBox.maxZ - 0.001);
                        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
                        if (packetPlayer.level.hasChunksAt(min, max)) {
                            for (int x = min.getX(); x <= max.getX(); ++x) {
                                for (int y = min.getY(); y <= max.getY(); ++y) {
                                    for (int z = min.getZ(); z <= max.getZ(); ++z) {
                                        pos.set(x, y, z);
                                        Block block = packetPlayer.level.getBlockState((BlockPos)pos).getBlock();
                                        if (!((TrackableBlockBridge)block).bridge$hasEntityInsideLogic()) continue;
                                        ignoreMovementCapture = false;
                                    }
                                }
                            }
                        }
                    }
                } else {
                    ignoreMovementCapture = false;
                }
                if (ignoreMovementCapture || packetIn instanceof ServerboundClientInformationPacket) {
                    packetIn.handle(netHandler);
                }
                IPhaseState<PacketContext<?>> packetState = PacketPhase.getInstance().getStateForPacket(packetIn);
                PacketContext<?> context = packetState.createPhaseContext(PhaseTracker.SERVER);
                ((PacketContext)((PacketContext)context.source(packetPlayer)).packetPlayer(packetPlayer)).packet(packetIn);
                if (!PacketPhase.getInstance().isPacketInvalid(packetIn, packetPlayer, packetState)) {
                    PacketPhase.getInstance().populateContext(packetIn, packetPlayer, packetState, context);
                    context.creator(((ServerPlayer)packetPlayer).uniqueId());
                    context.notifier(((ServerPlayer)packetPlayer).uniqueId());
                }
                try (PacketContext<?> packetContext = context;){
                    packetContext.buildAndSwitch();
                    packetIn.handle(netHandler);
                }
            }
        } else {
            packetIn.handle(netHandler);
        }
    }

    public static @Nullable EntityDataAccessor<?> findModifiedEntityInteractDataParameter(ItemStack stack, Entity entity) {
        Item item = stack.getItem();
        if (item instanceof DyeItem) {
            if (entity instanceof Sheep) {
                return SheepAccessor.accessor$DATA_WOOL_ID();
            }
            if (entity instanceof Wolf) {
                return WolfAccessor.accessor$DATA_COLLAR_COLOR();
            }
            return null;
        }
        if (item == Items.NAME_TAG) {
            return entity instanceof LivingEntity && !(entity instanceof Player) && stack.hasCustomHoverName() ? EntityAccessor.accessor$DATA_CUSTOM_NAME() : null;
        }
        if (item == Items.SADDLE) {
            return entity instanceof Pig ? PigAccessor.accessor$DATA_SADDLE_ID() : null;
        }
        if (item instanceof BlockItem && ((BlockItem)item).getBlock() == Blocks.CHEST) {
            return entity instanceof AbstractChestedHorse ? AbstractChestedHorseEntityAccessor.accessor$DATA_ID_CHEST() : null;
        }
        return null;
    }
}

