/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.inventory;

import java.util.Arrays;
import net.minecraft.core.Direction;
import net.minecraft.world.WorldlyContainer;
import org.spongepowered.api.item.inventory.BlockCarrier;
import org.spongepowered.api.item.inventory.Carrier;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.SingleBlockCarrier;
import org.spongepowered.api.item.inventory.query.Query;
import org.spongepowered.api.item.inventory.query.QueryTypes;
import org.spongepowered.api.item.inventory.slot.SlotMatchers;
import org.spongepowered.api.item.inventory.type.CarriedInventory;
import org.spongepowered.common.inventory.EmptyInventoryImpl;
import org.spongepowered.common.registry.provider.DirectionFacingProvider;
import org.spongepowered.common.util.MissingImplementationException;

public interface DefaultSingleBlockCarrier
extends SingleBlockCarrier {
    @Override
    default public Inventory inventory(org.spongepowered.api.util.Direction from) {
        return DefaultSingleBlockCarrier.inventory(from, this);
    }

    @Override
    default public CarriedInventory<? extends Carrier> inventory() {
        if (this instanceof CarriedInventory) {
            return (CarriedInventory)((Object)this);
        }
        throw new MissingImplementationException("SingleBlockCarrier", "inventory");
    }

    public static Inventory inventory(org.spongepowered.api.util.Direction from, BlockCarrier thisThing) {
        if (thisThing instanceof WorldlyContainer) {
            Direction facing = DirectionFacingProvider.INSTANCE.get(from).get();
            int[] slots = ((WorldlyContainer)thisThing).getSlotsForFace(facing);
            if (slots.length == 0) {
                return new EmptyInventoryImpl(thisThing.inventory());
            }
            Query.Builder builder = Query.builder();
            Arrays.stream(slots).mapToObj(slot -> QueryTypes.KEY_VALUE.get().of(SlotMatchers.index(slot))).forEach(xva$0 -> builder.and((Query)xva$0));
            Query query = builder.build();
            return thisThing.inventory().query(query);
        }
        return thisThing.inventory();
    }
}

