/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.inventory;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.world.SimpleContainer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.item.inventory.Carrier;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.common.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.inventory.custom.CustomInventory;
import org.spongepowered.common.inventory.lens.CompoundSlotLensProvider;
import org.spongepowered.common.inventory.lens.Lens;
import org.spongepowered.common.inventory.lens.impl.CompoundLens;
import org.spongepowered.common.inventory.lens.impl.DefaultIndexedLens;
import org.spongepowered.common.inventory.lens.impl.DelegatingLens;
import org.spongepowered.common.inventory.lens.impl.LensRegistrar;
import org.spongepowered.common.inventory.lens.impl.comp.GridInventoryLens;
import org.spongepowered.plugin.PluginContainer;

public class SpongeInventoryBuilder
implements Inventory.Builder,
Inventory.Builder.BuildingStep,
Inventory.Builder.EndStep {
    private final List<Lens> lenses = new ArrayList<Lens>();
    private final List<Inventory> inventories = new ArrayList<Inventory>();
    private PluginContainer plugin;
    private int size = 0;
    private Lens finalLens;
    private @Nullable UUID identity;
    private @Nullable Carrier carrier;
    private CompoundSlotLensProvider finalProvider;

    @Override
    public Inventory.Builder.BuildingStep slots(int amount) {
        this.size += amount;
        SimpleContainer adapter = new SimpleContainer(amount);
        this.inventories.add((Inventory)adapter);
        this.lenses.add(new DefaultIndexedLens(0, amount, ((InventoryAdapter)adapter).inventoryAdapter$getSlotLensProvider()));
        return this;
    }

    @Override
    public Inventory.Builder.BuildingStep grid(int sizeX, int sizeY) {
        this.size += sizeX * sizeY;
        SimpleContainer adapter = new SimpleContainer(sizeX * sizeY);
        this.lenses.add(new GridInventoryLens(0, sizeX, sizeY, ((InventoryAdapter)adapter).inventoryAdapter$getSlotLensProvider()));
        this.inventories.add((Inventory)adapter);
        return this;
    }

    @Override
    public Inventory.Builder.BuildingStep inventory(Inventory inventory) {
        InventoryAdapter adapter = (InventoryAdapter)((Object)inventory);
        this.size += inventory.capacity();
        this.lenses.add(adapter.inventoryAdapter$getRootLens());
        this.inventories.add(inventory);
        return this;
    }

    @Override
    public Inventory.Builder.EndStep completeStructure() {
        CompoundLens.Builder lensBuilder = CompoundLens.builder();
        int size = 0;
        for (Lens lens : this.lenses) {
            size += lens.slotCount();
        }
        LensRegistrar.BasicSlotLensProvider lensProvider = new LensRegistrar.BasicSlotLensProvider(size);
        int offset = 0;
        for (Lens lens : this.lenses) {
            lensBuilder.add(new DelegatingLens(offset, lens, lensProvider));
            offset += lens.slotCount();
        }
        this.finalLens = lensBuilder.build(lensProvider);
        return this;
    }

    @Override
    public Inventory.Builder.EndStep plugin(PluginContainer plugin) {
        this.plugin = Objects.requireNonNull(plugin, "plugin");
        return this;
    }

    @Override
    public Inventory.Builder.EndStep identity(UUID uuid) {
        this.identity = uuid;
        return this;
    }

    @Override
    public Inventory.Builder.EndStep carrier(Carrier carrier) {
        this.carrier = carrier;
        return this;
    }

    @Override
    public Inventory build() {
        if (this.plugin == null) {
            throw new IllegalStateException("Plugin has not been set in this builder!");
        }
        return (Inventory)((Object)new CustomInventory(this.plugin, this.size, this.finalLens, this.finalProvider, this.inventories, this.identity, this.carrier));
    }

    @Override
    public Inventory.Builder reset() {
        this.plugin = null;
        this.lenses.clear();
        this.inventories.clear();
        this.size = 0;
        this.finalLens = null;
        this.finalProvider = null;
        this.identity = null;
        this.carrier = null;
        return this;
    }
}

