/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.inventory.adapter.impl.comp;

import java.util.Optional;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.api.item.inventory.transaction.InventoryTransactionResult;
import org.spongepowered.api.item.inventory.type.GridInventory;
import org.spongepowered.api.item.inventory.type.InventoryColumn;
import org.spongepowered.api.item.inventory.type.InventoryRow;
import org.spongepowered.common.inventory.adapter.impl.AdapterLogic;
import org.spongepowered.common.inventory.adapter.impl.BasicInventoryAdapter;
import org.spongepowered.common.inventory.adapter.impl.comp.Inventory2DAdapter;
import org.spongepowered.common.inventory.fabric.Fabric;
import org.spongepowered.common.inventory.lens.impl.comp.GridInventoryLens;
import org.spongepowered.common.inventory.lens.impl.comp.InventoryColumnLens;
import org.spongepowered.common.inventory.lens.impl.comp.InventoryRowLens;
import org.spongepowered.math.vector.Vector2i;

public class GridInventoryAdapter
extends Inventory2DAdapter
implements GridInventory {
    protected final GridInventoryLens gridLens;

    public GridInventoryAdapter(Fabric fabric, GridInventoryLens root) {
        this(fabric, root, null);
    }

    public GridInventoryAdapter(Fabric fabric, GridInventoryLens root, Inventory parent) {
        super(fabric, root, parent);
        this.gridLens = root;
    }

    @Override
    public int columns() {
        return this.lens2d.getWidth();
    }

    @Override
    public int rows() {
        return this.lens2d.getHeight();
    }

    @Override
    public Vector2i dimensions() {
        return new Vector2i(this.columns(), this.rows());
    }

    @Override
    public Optional<Slot> slot(int x, int y) {
        return BasicInventoryAdapter.forSlot(this.inventoryAdapter$getFabric(), this.getSlotLens(x, y), this);
    }

    @Override
    public Optional<InventoryRow> row(int y) {
        try {
            InventoryRowLens rowLens = this.gridLens.getRow(y);
            return Optional.ofNullable((InventoryRow)rowLens.getAdapter(this.inventoryAdapter$getFabric(), this));
        }
        catch (IndexOutOfBoundsException ex) {
            return Optional.empty();
        }
    }

    @Override
    public Optional<InventoryColumn> column(int x) {
        try {
            InventoryColumnLens columnLens = this.gridLens.getColumn(x);
            return Optional.ofNullable((InventoryColumn)columnLens.getAdapter(this.inventoryAdapter$getFabric(), this));
        }
        catch (IndexOutOfBoundsException ex) {
            return Optional.empty();
        }
    }

    @Override
    public InventoryTransactionResult.Poll poll(int x, int y) {
        return AdapterLogic.pollSequential(this.inventoryAdapter$getFabric(), this.getSlotLens(x, y), null);
    }

    @Override
    public InventoryTransactionResult.Poll poll(int x, int y, int limit) {
        return AdapterLogic.pollSequential(this.inventoryAdapter$getFabric(), this.getSlotLens(x, y), limit);
    }

    @Override
    public Optional<ItemStack> peek(int x, int y) {
        return AdapterLogic.peekSequential(this.inventoryAdapter$getFabric(), this.getSlotLens(x, y));
    }

    @Override
    public InventoryTransactionResult set(int x, int y, ItemStack stack) {
        return AdapterLogic.insertSequential(this.inventoryAdapter$getFabric(), this.getSlotLens(x, y), stack);
    }
}

