/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.inventory.adapter.impl.slots;

import java.util.function.Predicate;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.equipment.EquipmentType;
import org.spongepowered.api.item.inventory.slot.EquipmentSlot;
import org.spongepowered.api.item.inventory.transaction.InventoryTransactionResult;
import org.spongepowered.common.inventory.adapter.impl.slots.SlotAdapter;
import org.spongepowered.common.inventory.fabric.Fabric;
import org.spongepowered.common.inventory.lens.impl.slot.HeldHandSlotLens;
import org.spongepowered.common.item.util.ItemStackUtil;

public class HeldSlotAdapter
extends SlotAdapter
implements EquipmentSlot {
    protected final HeldHandSlotLens equipmentSlot;

    public HeldSlotAdapter(Fabric fabric, HeldHandSlotLens lens, Inventory parent) {
        super(fabric, lens, parent);
        this.equipmentSlot = lens;
    }

    @Override
    public boolean isValidItem(EquipmentType type) {
        Predicate<EquipmentType> filter = this.equipmentSlot.getEquipmentTypeFilter();
        return filter == null || filter.test(type);
    }

    @Override
    public boolean isValidItem(ItemStack stack) {
        Predicate<ItemStack> filter = this.equipmentSlot.getItemStackFilter();
        return filter == null || filter.test(stack);
    }

    @Override
    public boolean isValidItem(ItemType type) {
        Predicate<ItemType> filter = this.equipmentSlot.getItemTypeFilter();
        return filter == null || filter.test(type);
    }

    @Override
    public InventoryTransactionResult set(ItemStack stack) {
        boolean canSet = this.isValidItem(stack);
        if (!canSet) {
            InventoryTransactionResult.Builder result = InventoryTransactionResult.builder().type(InventoryTransactionResult.Type.FAILURE);
            result.reject(ItemStackUtil.cloneDefensive(stack));
            return result.build();
        }
        return super.set(stack);
    }
}

