/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.inventory.adapter.impl.slots;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.StringJoiner;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.ItemTypes;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.api.item.inventory.transaction.InventoryTransactionResult;
import org.spongepowered.api.item.inventory.transaction.SlotTransaction;
import org.spongepowered.common.inventory.adapter.impl.BasicInventoryAdapter;
import org.spongepowered.common.inventory.fabric.Fabric;
import org.spongepowered.common.inventory.lens.slots.SlotLens;
import org.spongepowered.common.item.util.ItemStackUtil;

public class SlotAdapter
extends BasicInventoryAdapter
implements Slot {
    private final int ordinal;
    private final ImmutableList<Slot> slots;
    private final SlotLens slot;

    public SlotAdapter(Fabric fabric, SlotLens lens, Inventory parent) {
        super(fabric, lens, parent);
        this.slot = lens;
        this.ordinal = lens.getOrdinal(fabric);
        this.slots = ImmutableList.of((Object)this);
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    @Override
    public List<Slot> slots() {
        return this.slots;
    }

    @Override
    public InventoryTransactionResult.Poll poll() {
        ItemStack stack = this.inventoryAdapter$getFabric().fabric$getStack(this.ordinal);
        if (stack.isEmpty()) {
            return InventoryTransactionResult.builder().type(InventoryTransactionResult.Type.FAILURE).poll(ItemStackSnapshot.empty()).build();
        }
        this.inventoryAdapter$getFabric().fabric$setStack(this.ordinal, ItemStack.EMPTY);
        return InventoryTransactionResult.builder().type(InventoryTransactionResult.Type.SUCCESS).transaction(new SlotTransaction(this, ItemStackUtil.snapshotOf(stack), ItemStackSnapshot.empty())).poll(ItemStackUtil.snapshotOf(stack)).build();
    }

    @Override
    public org.spongepowered.api.item.inventory.ItemStack peek() {
        ItemStack stack = this.slot.getStack(this.inventoryAdapter$getFabric());
        return ItemStackUtil.cloneDefensive(stack);
    }

    @Override
    public InventoryTransactionResult offer(org.spongepowered.api.item.inventory.ItemStack ... stacks) {
        InventoryTransactionResult.Builder result = InventoryTransactionResult.builder().type(InventoryTransactionResult.Type.SUCCESS);
        for (org.spongepowered.api.item.inventory.ItemStack stack : stacks) {
            ItemStackSnapshot oldStack;
            ItemStack nativeStack = ItemStackUtil.toNative(stack);
            int maxStackSize = this.slot.getMaxStackSize(this.inventoryAdapter$getFabric());
            int remaining = stack.quantity();
            ItemStack old = this.slot.getStack(this.inventoryAdapter$getFabric());
            ItemStackSnapshot newStack = oldStack = ItemStackUtil.snapshotOf(old);
            int push = Math.min(remaining, maxStackSize);
            if (old.isEmpty() && this.slot.setStack(this.inventoryAdapter$getFabric(), ItemStackUtil.cloneDefensiveNative(nativeStack, push))) {
                remaining -= push;
                newStack = ItemStackUtil.snapshotOf(stack);
            } else if (!old.isEmpty() && ItemStackUtil.compareIgnoreQuantity(old, stack)) {
                this.inventoryAdapter$getFabric().fabric$markDirty();
                push = Math.max(Math.min(maxStackSize - old.getCount(), remaining), 0);
                old.setCount(old.getCount() + push);
                remaining -= push;
                newStack = ItemStackUtil.snapshotOf(old);
            }
            result.transaction(new SlotTransaction(this, oldStack, newStack));
            if (remaining != stack.quantity()) continue;
            result.reject(ItemStackUtil.cloneDefensive(nativeStack));
            result.type(InventoryTransactionResult.Type.FAILURE);
        }
        return result.build();
    }

    @Override
    public boolean canFit(org.spongepowered.api.item.inventory.ItemStack stack) {
        if (stack.isEmpty()) {
            return true;
        }
        int maxStackSize = this.inventoryAdapter$getFabric().fabric$getMaxStackSize();
        ItemStack old = this.slot.getStack(this.inventoryAdapter$getFabric());
        if (old.isEmpty()) {
            return maxStackSize >= stack.quantity();
        }
        return ItemStackUtil.compareIgnoreQuantity(old, stack) && maxStackSize - old.getCount() >= stack.quantity();
    }

    @Override
    public InventoryTransactionResult set(org.spongepowered.api.item.inventory.ItemStack stack) {
        InventoryTransactionResult.Builder result = InventoryTransactionResult.builder().type(InventoryTransactionResult.Type.SUCCESS);
        ItemStack nativeStack = ItemStackUtil.toNative(stack);
        ItemStack old = this.slot.getStack(this.inventoryAdapter$getFabric());
        ItemStackSnapshot oldSnap = ItemStackUtil.snapshotOf(old);
        if (stack.isEmpty()) {
            this.clear();
            SlotTransaction trans = new SlotTransaction(this, oldSnap, ItemStackSnapshot.empty());
            return result.transaction(trans).build();
        }
        int remaining = stack.quantity();
        int push = Math.min(remaining, this.slot.getMaxStackSize(this.inventoryAdapter$getFabric()));
        ItemStack newStack = ItemStackUtil.cloneDefensiveNative(nativeStack, push);
        if (this.slot.setStack(this.inventoryAdapter$getFabric(), newStack)) {
            result.transaction(new SlotTransaction(this, oldSnap, ItemStackUtil.snapshotOf(newStack)));
            remaining -= push;
        }
        if (remaining > 0) {
            result.reject(ItemStackUtil.cloneDefensive(nativeStack, remaining));
        }
        return result.build();
    }

    @Override
    public void clear() {
        this.slot.setStack(this.inventoryAdapter$getFabric(), ItemStack.EMPTY);
    }

    @Override
    public int freeCapacity() {
        return this.slot.getStack(this.inventoryAdapter$getFabric()).isEmpty() ? 1 : 0;
    }

    @Override
    public int totalQuantity() {
        return this.slot.getStack(this.inventoryAdapter$getFabric()).getCount();
    }

    @Override
    public int capacity() {
        return 1;
    }

    @Override
    public boolean hasChildren() {
        return false;
    }

    @Override
    public boolean contains(org.spongepowered.api.item.inventory.ItemStack stack) {
        ItemStack slotStack = this.slot.getStack(this.inventoryAdapter$getFabric());
        return slotStack.isEmpty() ? ItemStackUtil.toNative(stack).isEmpty() : ItemStackUtil.compareIgnoreQuantity(slotStack, stack) && slotStack.getCount() >= stack.quantity();
    }

    @Override
    public boolean containsAny(org.spongepowered.api.item.inventory.ItemStack stack) {
        ItemStack slotStack = this.slot.getStack(this.inventoryAdapter$getFabric());
        return slotStack.isEmpty() ? ItemStackUtil.toNative(stack).isEmpty() : ItemStackUtil.compareIgnoreQuantity(slotStack, stack);
    }

    @Override
    public boolean contains(ItemType type) {
        ItemStack slotStack = this.slot.getStack(this.inventoryAdapter$getFabric());
        return slotStack.isEmpty() ? type == null || type == ItemTypes.AIR : slotStack.getItem().equals(type);
    }

    @Override
    public Slot viewedSlot() {
        Fabric fabric = this.inventoryAdapter$getFabric();
        if (fabric instanceof net.minecraft.world.inventory.Slot) {
            return (Slot)((Object)fabric);
        }
        if (fabric instanceof AbstractContainerMenu) {
            return (Slot)((AbstractContainerMenu)fabric).getSlot(this.ordinal);
        }
        return this;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", SlotAdapter.class.getSimpleName() + "[", "]").add("ordinal=" + this.ordinal).toString();
    }
}

