/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.inventory.custom;

import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.api.item.inventory.ContainerType;
import org.spongepowered.common.inventory.custom.CustomInventory;

public class CustomContainer
extends AbstractContainerMenu {
    public CustomInventory inv;

    public CustomContainer(int id, Player player, CustomInventory inventory, ContainerType type) {
        super((MenuType)type, id);
        this.inv = inventory;
        for (int slot = 0; slot < inventory.getContainerSize(); ++slot) {
            this.addSlot(new Slot((Container)inventory, slot, 0, 0));
        }
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.addSlot(new Slot((Container)player.inventory, (row + 1) * 9 + col, 0, 0));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.addSlot(new Slot((Container)player.inventory, col, 0, 0));
        }
    }

    public boolean stillValid(Player playerIn) {
        return true;
    }

    public void removed(Player playerIn) {
        super.removed(playerIn);
        this.inv.stopOpen(playerIn);
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index < this.inv.getContainerSize() ? !this.moveItemStackTo(itemstack1, this.inv.getContainerSize(), this.slots.size(), true) : !this.moveItemStackTo(itemstack1, 0, this.inv.getContainerSize(), false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemstack;
    }
}

