/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.inventory.lens.impl.comp;

import net.minecraft.world.item.ItemStack;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.crafting.CraftingInventory;
import org.spongepowered.common.inventory.adapter.impl.comp.CraftingInventoryAdapter;
import org.spongepowered.common.inventory.fabric.Fabric;
import org.spongepowered.common.inventory.lens.impl.DefaultIndexedLens;
import org.spongepowered.common.inventory.lens.impl.comp.CraftingGridInventoryLens;
import org.spongepowered.common.inventory.lens.impl.slot.CraftingOutputSlotLens;
import org.spongepowered.common.inventory.lens.impl.slot.FilteringSlotLens;
import org.spongepowered.common.inventory.lens.impl.slot.SlotLensProvider;
import org.spongepowered.common.inventory.property.KeyValuePair;

public class CraftingInventoryLens
extends DefaultIndexedLens {
    private final int outputSlotIndex;
    private final CraftingOutputSlotLens outputSlot;
    private final CraftingGridInventoryLens craftingGrid;

    public CraftingInventoryLens(int outputSlotIndex, int gridBase, int width, int height, SlotLensProvider slots) {
        super(0, width * height + 1, 1, CraftingInventory.class, slots);
        this.outputSlotIndex = outputSlotIndex;
        this.outputSlot = new CraftingOutputSlotLens(slots.getSlotLens(this.outputSlotIndex), FilteringSlotLens.ItemStackFilter.filterNone());
        this.craftingGrid = new CraftingGridInventoryLens(gridBase, width, height, slots);
        this.addChild(this.outputSlot, KeyValuePair.slotIndex(0));
        this.addChild(this.craftingGrid, new KeyValuePair[0]);
    }

    public CraftingGridInventoryLens getCraftingGrid() {
        return this.craftingGrid;
    }

    public CraftingOutputSlotLens getOutputSlot() {
        return this.outputSlot;
    }

    public ItemStack getOutputStack(Fabric fabric) {
        return this.outputSlot.getStack(fabric);
    }

    public boolean setOutputStack(Fabric fabric, ItemStack stack) {
        return this.outputSlot.setStack(fabric, stack);
    }

    @Override
    public Inventory getAdapter(Fabric fabric, Inventory parent) {
        return new CraftingInventoryAdapter(fabric, this, parent);
    }
}

