/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.commands.arguments.selector;

import com.google.common.base.Preconditions;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.WrappedMinMaxBounds;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.commands.arguments.selector.EntitySelectorParser;
import net.minecraft.core.Registry;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.advancement.Advancement;
import org.spongepowered.api.advancement.criteria.AdvancementCriterion;
import org.spongepowered.api.command.selector.Selector;
import org.spongepowered.api.command.selector.SelectorSortAlgorithm;
import org.spongepowered.api.command.selector.SelectorType;
import org.spongepowered.api.data.persistence.DataFormats;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.living.player.gamemode.GameMode;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.api.scoreboard.Team;
import org.spongepowered.api.scoreboard.objective.Objective;
import org.spongepowered.api.util.Range;
import org.spongepowered.api.util.Tristate;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.accessor.advancements.critereon.MinMaxBounds_FloatsAccessor;
import org.spongepowered.common.accessor.advancements.critereon.MinMaxBounds_IntsAccessor;
import org.spongepowered.common.bridge.commands.arguments.selector.EntitySelectorParserBridge;
import org.spongepowered.common.command.selector.SpongeSelectorSortAlgorithm;
import org.spongepowered.math.vector.Vector3d;

@Mixin(value={EntitySelectorParser.class})
public abstract class EntitySelectorParserMixin_API
implements Selector.Builder {
    @Shadow
    @Final
    private StringReader reader;
    @Shadow
    private int maxResults;
    @Shadow
    private BiConsumer<Vec3, List<? extends net.minecraft.world.entity.Entity>> order;
    @Shadow
    private MinMaxBounds.Floats distance;
    @Shadow
    private MinMaxBounds.Ints level;
    @Shadow
    private boolean includesEntities;
    @Shadow
    private boolean worldLimited;
    @Shadow
    private @Nullable Double x;
    @Shadow
    private @Nullable Double y;
    @Shadow
    private @Nullable Double z;
    @Shadow
    private @Nullable Double deltaX;
    @Shadow
    private @Nullable Double deltaY;
    @Shadow
    private @Nullable Double deltaZ;
    @Shadow
    private WrappedMinMaxBounds rotX = WrappedMinMaxBounds.ANY;
    @Shadow
    private WrappedMinMaxBounds rotY = WrappedMinMaxBounds.ANY;
    @Shadow
    private Predicate<net.minecraft.world.entity.Entity> predicate;
    @Shadow
    private boolean currentEntity;
    @Shadow
    private @Nullable String playerName;
    @Shadow
    private int startPosition;
    @Shadow
    private @Nullable UUID entityUUID;
    @Shadow
    private BiFunction<SuggestionsBuilder, Consumer<SuggestionsBuilder>, CompletableFuture<Suggestions>> suggestions;
    @Shadow
    private boolean hasNameEquals;
    @Shadow
    private boolean hasNameNotEquals;
    @Shadow
    private boolean isLimited;
    @Shadow
    private boolean isSorted;
    @Shadow
    private boolean hasGamemodeEquals;
    @Shadow
    private boolean hasGamemodeNotEquals;
    @Shadow
    private boolean hasTeamEquals;
    @Shadow
    private boolean hasTeamNotEquals;
    @Shadow
    private @Nullable net.minecraft.world.entity.EntityType<?> type;
    @Shadow
    private boolean typeInverse;
    @Shadow
    private boolean hasScores;
    @Shadow
    private boolean hasAdvancements;
    @Shadow
    private boolean usesSelectors;
    private @Nullable Map<String, Range<@NonNull Integer>> api$scores;
    private @Nullable Object2BooleanOpenHashMap<String> api$advancement;
    private @Nullable Map<String, Object2BooleanOpenHashMap<String>> api$criterion;
    private boolean api$forceSelf;

    @Shadow
    public abstract void shadow$setLimited(boolean var1);

    @Shadow
    public abstract void shadow$setSorted(boolean var1);

    @Shadow
    public abstract void shadow$setX(double var1);

    @Shadow
    public abstract void shadow$setY(double var1);

    @Shadow
    public abstract void shadow$setZ(double var1);

    @Shadow
    public abstract void shadow$setDeltaX(double var1);

    @Shadow
    public abstract void shadow$setDeltaY(double var1);

    @Shadow
    public abstract void shadow$setDeltaZ(double var1);

    @Shadow
    public abstract void shadow$setIncludesEntities(boolean var1);

    @Shadow
    public abstract EntitySelector shadow$getSelector();

    @Shadow
    public abstract void shadow$addPredicate(Predicate<net.minecraft.world.entity.Entity> var1);

    @Override
    public @NonNull Selector.Builder applySelectorType(Supplier<? extends SelectorType> selectorType) {
        return this.applySelectorType(selectorType.get());
    }

    @Override
    public @NonNull Selector.Builder applySelectorType(@NonNull SelectorType selectorType) {
        try {
            ((EntitySelectorParserBridge)((Object)this)).bridge$parseSelector(selectorType);
        }
        catch (CommandSyntaxException commandSyntaxException) {
            throw new IllegalArgumentException("Could not parse provided SelectorType", commandSyntaxException);
        }
        return this;
    }

    @Override
    public @NonNull Selector.Builder includeSelf() {
        this.api$forceSelf = true;
        return this;
    }

    @Override
    public @NonNull Selector.Builder limit(int limit) {
        this.maxResults = limit;
        this.shadow$setLimited(limit != Integer.MAX_VALUE);
        return this;
    }

    @Override
    public @NonNull Selector.Builder distance(@NonNull Range<@NonNull Double> range) {
        if (range.min() != null && range.min() < 0.0) {
            throw new IllegalArgumentException("min must be non-negative");
        }
        if (range.max() != null && range.max() < 0.0) {
            throw new IllegalArgumentException("max must be non-negative");
        }
        this.distance = MinMaxBounds_FloatsAccessor.invoker$new(this.api$floatFromDouble(range.min(), Function.identity()), this.api$floatFromDouble(range.max(), Function.identity()));
        return this;
    }

    @Override
    public @NonNull Selector.Builder volume(@NonNull Vector3d corner1, @NonNull Vector3d corner2) {
        Vector3d minPoint = corner1.min(corner2);
        Vector3d distance = corner1.max(corner2).sub(minPoint);
        this.shadow$setX(minPoint.x());
        this.shadow$setY(minPoint.y());
        this.shadow$setZ(minPoint.z());
        this.shadow$setDeltaX(distance.x());
        this.shadow$setDeltaY(distance.y());
        this.shadow$setDeltaZ(distance.z());
        return this;
    }

    @Override
    public @NonNull Selector.Builder sortAlgorithm(@NonNull Supplier<? extends SelectorSortAlgorithm> algorithm) {
        return this.sortAlgorithm(algorithm.get());
    }

    @Override
    public @NonNull Selector.Builder sortAlgorithm(@NonNull SelectorSortAlgorithm algorithm) {
        Preconditions.checkArgument((boolean)(algorithm instanceof SpongeSelectorSortAlgorithm), (Object)"Must be a SpongeSelectorSortAlgorithm");
        this.shadow$setSorted(true);
        this.order = ((SpongeSelectorSortAlgorithm)algorithm).getSortAlgorithm();
        return this;
    }

    @Override
    public @NonNull Selector.Builder addAdvancement(@NonNull Advancement advancement) {
        return this.api$advancement(advancement, false);
    }

    @Override
    public @NonNull Selector.Builder addNotAdvancement(@NonNull Advancement advancement) {
        return this.api$advancement(advancement, true);
    }

    @Override
    public @NonNull Selector.Builder addAdvancementCriterion(@NonNull Advancement advancement, @NonNull AdvancementCriterion criterion) {
        return this.api$advancementCriterion(advancement, criterion, false);
    }

    @Override
    public @NonNull Selector.Builder addNotAdvancementCriterion(@NonNull Advancement advancement, @NonNull AdvancementCriterion criterion) {
        return this.api$advancementCriterion(advancement, criterion, true);
    }

    @Override
    public @NonNull Selector.Builder dataView(@NonNull DataView view) {
        try {
            String json = DataFormats.JSON.get().write(view);
            this.api$handle("nbt", json);
            return this;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not create JSON representation of DataView", e);
        }
    }

    @Override
    public @NonNull Selector.Builder addNotEntityType(@NonNull Supplier<@NonNull EntityType<@NonNull ?>> type) {
        return this.addNotEntityType(type.get());
    }

    @Override
    public @NonNull Selector.Builder addNotEntityType(@NonNull EntityType<@NonNull ?> type) {
        ResourceKey key = (ResourceKey)Registry.ENTITY_TYPE.getKey((Object)((net.minecraft.world.entity.EntityType)type));
        this.api$handle("type", "!" + key.asString());
        return this;
    }

    @Override
    public @NonNull Selector.Builder addEntityType(@NonNull Supplier<@NonNull EntityType<@NonNull ?>> type, boolean inherit) {
        return this.addEntityType(type.get(), inherit);
    }

    @Override
    public @NonNull Selector.Builder addEntityType(@NonNull EntityType<@NonNull ?> type, boolean inherit) {
        ResourceKey key = (ResourceKey)Registry.ENTITY_TYPE.getKey((Object)((net.minecraft.world.entity.EntityType)type));
        this.api$handle("type", String.format("%s%s", inherit ? "#" : "", key.asString()));
        return this;
    }

    @Override
    public @NonNull Selector.Builder experienceLevel(@NonNull Range<@NonNull Integer> range) {
        Preconditions.checkArgument((range.min() == null || range.min() >= 0 ? 1 : 0) != 0, (Object)"min must be non-negative");
        Preconditions.checkArgument((range.max() == null || range.max() >= 0 ? 1 : 0) != 0, (Object)"max must be non-negative");
        this.level = MinMaxBounds_IntsAccessor.invoker$new(range.min(), range.max());
        this.shadow$setIncludesEntities(false);
        return this;
    }

    @Override
    public @NonNull Selector.Builder addGameMode(@NonNull Supplier<? extends GameMode> mode) {
        return this.addGameMode(mode.get());
    }

    @Override
    public @NonNull Selector.Builder addGameMode(@NonNull GameMode mode) {
        ResourceKey key = Sponge.game().registry(RegistryTypes.GAME_MODE).valueKey(mode);
        this.api$handle("gamemode", key.value(), Tristate.FALSE);
        return this;
    }

    @Override
    public @NonNull Selector.Builder addNotGameMode(@NonNull Supplier<? extends GameMode> mode) {
        return this.addNotGameMode(mode.get());
    }

    @Override
    public @NonNull Selector.Builder addNotGameMode(@NonNull GameMode mode) {
        ResourceKey key = Sponge.game().registry(RegistryTypes.GAME_MODE).valueKey(mode);
        this.api$handle("gamemode", key.value(), Tristate.TRUE);
        return this;
    }

    @Override
    public @NonNull Selector.Builder noTeam() {
        this.api$handle("team", "", Tristate.TRUE);
        return this;
    }

    @Override
    public @NonNull Selector.Builder anyTeam() {
        this.api$handle("team", "", Tristate.FALSE);
        return this;
    }

    @Override
    public @NonNull Selector.Builder addTeam(@NonNull Team team) {
        this.api$handle("team", team.name(), Tristate.FALSE);
        return this;
    }

    @Override
    public @NonNull Selector.Builder addNotTeam(@NonNull Team team) {
        this.api$handle("team", team.name(), Tristate.TRUE);
        return this;
    }

    @Override
    public @NonNull Selector.Builder addName(@NonNull String name) {
        this.api$handle("name", name, Tristate.FALSE);
        return this;
    }

    @Override
    public @NonNull Selector.Builder addNotName(@NonNull String name) {
        this.api$handle("name", name, Tristate.TRUE);
        return this;
    }

    @Override
    public @NonNull Selector.Builder addObjective(@NonNull Objective objective, @NonNull Range<@NonNull Integer> range) {
        if (this.api$scores == null) {
            this.api$scores = new HashMap<String, Range<Integer>>();
        }
        this.api$scores.put(objective.name(), range);
        return this;
    }

    @Override
    public @NonNull Selector.Builder addTag(@NonNull String tag) {
        this.api$handle("tag", tag, Tristate.FALSE);
        return this;
    }

    @Override
    public @NonNull Selector.Builder addNotTag(@NonNull String tag) {
        this.api$handle("tag", tag, Tristate.TRUE);
        return this;
    }

    @Override
    public @NonNull Selector.Builder pitch(@NonNull Range<@NonNull Double> range) {
        this.rotX = this.api$getWrappedBounds(range);
        return this;
    }

    @Override
    public @NonNull Selector.Builder yaw(@NonNull Range<@NonNull Double> range) {
        this.rotY = this.api$getWrappedBounds(range);
        return this;
    }

    @Override
    public @NonNull Selector.Builder addFilter(@NonNull Predicate<@NonNull Entity> filter) {
        this.shadow$addPredicate(filter);
        return this;
    }

    @Override
    public @NonNull Selector build() throws IllegalStateException {
        ArrayList entries;
        if (this.api$advancement != null || this.api$criterion != null) {
            entries = new ArrayList();
            if (this.api$advancement != null) {
                this.api$advancement.object2BooleanEntrySet().fastForEach(x -> entries.add((String)x.getKey() + "=" + x.getBooleanValue()));
            }
            if (this.api$criterion != null) {
                this.api$criterion.forEach((key, value) -> value.object2BooleanEntrySet().fastForEach(x -> entries.add(key + "={" + (String)x.getKey() + "=" + x.getBooleanValue() + "}")));
            }
            this.api$handle("advancements", "{" + String.join((CharSequence)",", entries) + "}");
            this.api$advancement = null;
            this.api$criterion = null;
        }
        if (this.api$scores != null) {
            entries = new ArrayList();
            this.api$scores.forEach((key, range) -> entries.add(key + "=" + this.api$intRangeToStringRepresentation((Range<Integer>)range)));
            this.api$handle("scores", "{" + String.join((CharSequence)",", entries) + "}");
            this.api$scores = null;
        }
        if (this.api$forceSelf) {
            this.currentEntity = true;
        }
        return (Selector)this.shadow$getSelector();
    }

    @Override
    public @NonNull Selector.Builder reset() {
        this.order = EntitySelectorParser.ORDER_ARBITRARY;
        this.distance = MinMaxBounds.Floats.ANY;
        this.level = MinMaxBounds.Ints.ANY;
        this.includesEntities = false;
        this.worldLimited = false;
        this.x = null;
        this.y = null;
        this.z = null;
        this.deltaX = null;
        this.deltaY = null;
        this.deltaZ = null;
        this.rotX = WrappedMinMaxBounds.ANY;
        this.rotY = WrappedMinMaxBounds.ANY;
        this.predicate = x -> true;
        this.currentEntity = false;
        this.playerName = null;
        this.startPosition = 0;
        this.entityUUID = null;
        this.hasNameEquals = false;
        this.hasNameNotEquals = false;
        this.isLimited = false;
        this.isSorted = false;
        this.hasGamemodeEquals = false;
        this.hasGamemodeNotEquals = false;
        this.hasTeamEquals = false;
        this.hasTeamNotEquals = false;
        this.type = null;
        this.typeInverse = false;
        this.hasScores = false;
        this.hasAdvancements = false;
        this.usesSelectors = false;
        this.reader.setCursor(0);
        this.suggestions = EntitySelectorParser.SUGGEST_NOTHING;
        this.api$forceSelf = false;
        return this;
    }

    private @NonNull Selector.Builder api$advancement(@NonNull Advancement advancement, boolean inverted) {
        if (this.api$advancement == null) {
            this.api$advancement = new Object2BooleanOpenHashMap();
        }
        this.api$advancement.put((Object)advancement.key().asString(), inverted);
        return this;
    }

    private @NonNull Selector.Builder api$advancementCriterion(@NonNull Advancement advancement, @NonNull AdvancementCriterion criterion, boolean inverted) {
        if (this.api$criterion == null) {
            this.api$criterion = new HashMap<String, Object2BooleanOpenHashMap<String>>();
        }
        this.api$criterion.computeIfAbsent(advancement.key().toString(), k -> new Object2BooleanOpenHashMap()).put((Object)criterion.name(), inverted);
        return this;
    }

    private void api$handle(@NonNull String name, @NonNull String value) {
        this.api$handle(name, value, Tristate.UNDEFINED);
    }

    private void api$handle(@NonNull String name, @NonNull String value, @NonNull Tristate invert) {
        try {
            ((EntitySelectorParserBridge)((Object)this)).bridge$handleValue(name, value, invert);
        }
        catch (CommandSyntaxException ex) {
            throw new IllegalArgumentException(String.format("Could not create selector criteria based on input (name = '%s', value = '%s', invert = %s)", name, value, invert.name()), ex);
        }
    }

    private @Nullable Float api$floatFromDouble(@Nullable Double d, Function<Float, Float> mapping) {
        if (d == null) {
            return null;
        }
        return mapping.apply(Float.valueOf(d.floatValue()));
    }

    private WrappedMinMaxBounds api$getWrappedBounds(Range<@NonNull Double> range) {
        Float a = this.api$floatFromDouble(range.min(), Mth::wrapDegrees);
        Float b = this.api$floatFromDouble(range.max(), Mth::wrapDegrees);
        if (a == null) {
            return new WrappedMinMaxBounds(null, b);
        }
        if (b == null) {
            return new WrappedMinMaxBounds(a, null);
        }
        if (a.floatValue() <= b.floatValue()) {
            return new WrappedMinMaxBounds(a, b);
        }
        return new WrappedMinMaxBounds(b, a);
    }

    private String api$intRangeToStringRepresentation(@NonNull Range<@NonNull Integer> range) {
        if (range.min() != null && range.max() != null && range.min().intValue() == range.max().intValue()) {
            return String.valueOf(range.max());
        }
        return String.format("%s..%s", range.min() == null ? "" : String.valueOf(range.min()), range.max() == null ? "" : String.valueOf(range.max()));
    }
}

