/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.world.level.chunk;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.util.ClassInstanceMultiMap;
import net.minecraft.util.Tuple;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.block.entity.BlockEntity;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.util.PositionOutOfBoundsException;
import org.spongepowered.api.world.BlockChangeFlag;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.WorldLike;
import org.spongepowered.api.world.biome.Biome;
import org.spongepowered.api.world.chunk.WorldChunk;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.api.world.volume.stream.StreamOptions;
import org.spongepowered.api.world.volume.stream.VolumeStream;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.bridge.world.level.LevelBridge;
import org.spongepowered.common.bridge.world.level.chunk.LevelChunkBridge;
import org.spongepowered.common.data.holder.SpongeLocationBaseDataHolder;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.util.MissingImplementationException;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.storage.SpongeChunkLayout;
import org.spongepowered.common.world.volume.VolumeStreamUtils;
import org.spongepowered.common.world.volume.buffer.biome.ObjectArrayMutableBiomeBuffer;
import org.spongepowered.common.world.volume.buffer.block.ArrayMutableBlockBuffer;
import org.spongepowered.common.world.volume.buffer.blockentity.ObjectArrayMutableBlockEntityBuffer;
import org.spongepowered.common.world.volume.buffer.entity.ObjectArrayMutableEntityBuffer;
import org.spongepowered.math.vector.Vector3d;
import org.spongepowered.math.vector.Vector3i;
import org.spongepowered.math.vector.Vectori;

@Mixin(value={LevelChunk.class})
@Implements(value={@Interface(iface=WorldChunk.class, prefix="worldChunk$", remap=Interface.Remap.NONE)})
public abstract class LevelChunkMixin_API
implements WorldChunk,
SpongeLocationBaseDataHolder {
    @Shadow
    @Final
    private ChunkPos chunkPos;
    @Shadow
    @Final
    private Level level;
    @Shadow
    @Final
    private ClassInstanceMultiMap<net.minecraft.world.entity.Entity>[] entitySections;
    private @Nullable Vector3i api$blockMin;
    private @Nullable Vector3i api$blockMax;

    @Shadow
    public abstract boolean shadow$isEmpty();

    @Shadow
    public abstract int shadow$getHeight(Heightmap.Types var1, int var2, int var3);

    @Shadow
    public abstract void shadow$setUnsaved(boolean var1);

    @Shadow
    public abstract <T extends net.minecraft.world.entity.Entity> void shadow$getEntitiesOfClass(Class<? extends T> var1, AABB var2, List<T> var3, @org.jetbrains.annotations.Nullable Predicate<? super T> var4);

    @Shadow
    public abstract void shadow$getEntities(@org.jetbrains.annotations.Nullable net.minecraft.world.entity.Entity var1, AABB var2, List<net.minecraft.world.entity.Entity> var3, @org.jetbrains.annotations.Nullable Predicate<? super net.minecraft.world.entity.Entity> var4);

    @Shadow
    public abstract Map<BlockPos, net.minecraft.world.level.block.entity.BlockEntity> shadow$getBlockEntities();

    @Shadow
    public abstract void shadow$setBlockEntity(BlockPos var1, net.minecraft.world.level.block.entity.BlockEntity var2);

    @Shadow
    public abstract void shadow$removeBlockEntity(BlockPos var1);

    @Override
    public Biome biome(int x, int y, int z) {
        if (!this.contains(x, y, z)) {
            throw new PositionOutOfBoundsException((Vectori)new Vector3i(x, y, z), (Vectori)Constants.World.BLOCK_MIN, (Vectori)Constants.World.BLOCK_MAX);
        }
        return (Biome)this.level.getBiome(new BlockPos(x, y, z));
    }

    @Override
    public double regionalDifficultyFactor() {
        return new DifficultyInstance(this.level.getDifficulty(), this.level.getDayTime(), this.inhabitedTime().ticks(), this.level.getMoonBrightness()).getEffectiveDifficulty();
    }

    @Override
    public double regionalDifficultyPercentage() {
        return new DifficultyInstance(this.level.getDifficulty(), this.level.getDayTime(), this.inhabitedTime().ticks(), this.level.getMoonBrightness()).getSpecialMultiplier();
    }

    @Override
    public World<@NonNull ?, @NonNull ?> world() {
        return (World)this.level;
    }

    @Intrinsic
    public boolean worldChunk$isEmpty() {
        return this.shadow$isEmpty();
    }

    @Override
    public VolumeStream<WorldChunk, Entity> entityStream(Vector3i min, Vector3i max, StreamOptions options) {
        VolumeStreamUtils.validateStreamArgs(Objects.requireNonNull(min, "min"), Objects.requireNonNull(max, "max"), Objects.requireNonNull(options, "options"));
        boolean shouldCarbonCopy = options.carbonCopy();
        Vector3i size = max.sub(min).add(1, 1, 1);
        ObjectArrayMutableEntityBuffer backingVolume = shouldCarbonCopy ? new ObjectArrayMutableEntityBuffer(min, size) : null;
        return VolumeStreamUtils.generateStream(options, this, (LevelChunk)this, chunk -> VolumeStreamUtils.getEntitiesFromChunk(min, max, chunk), VolumeStreamUtils.getOrCloneEntityWithVolume(shouldCarbonCopy, backingVolume, this.level), (key, entity) -> entity.getUUID(), (entityUuid, chunk) -> {
            net.minecraft.world.entity.Entity entity;
            net.minecraft.world.entity.Entity entity2 = entity = shouldCarbonCopy ? (net.minecraft.world.entity.Entity)backingVolume.entity((UUID)entityUuid).orElse(null) : (net.minecraft.world.entity.Entity)chunk.world().entity((UUID)entityUuid).orElse(null);
            if (entity == null) {
                return null;
            }
            return new Tuple((Object)entity.blockPosition(), (Object)entity);
        });
    }

    @Override
    public VolumeStream<WorldChunk, org.spongepowered.api.block.BlockState> blockStateStream(Vector3i min, Vector3i max, StreamOptions options) {
        VolumeStreamUtils.validateStreamArgs(Objects.requireNonNull(min, "min"), Objects.requireNonNull(max, "max"), Objects.requireNonNull(options, "options"));
        boolean shouldCarbonCopy = options.carbonCopy();
        Vector3i size = max.sub(min).add(1, 1, 1);
        ArrayMutableBlockBuffer backingVolume = shouldCarbonCopy ? new ArrayMutableBlockBuffer(min, size) : null;
        return VolumeStreamUtils.generateStream(options, this, (LevelChunk)this, VolumeStreamUtils.getBlockStatesForSections(min, max), (pos, blockState) -> {
            if (shouldCarbonCopy) {
                backingVolume.setBlock((BlockPos)pos, (BlockState)blockState);
            }
        }, (key, biome) -> key, (blockPos, world) -> {
            BlockState tileEntity = shouldCarbonCopy ? backingVolume.getBlock((BlockPos)blockPos) : ((LevelReader)world).getBlockState(blockPos);
            return new Tuple(blockPos, (Object)tileEntity);
        });
    }

    @Override
    public Collection<? extends BlockEntity> blockEntities() {
        return Collections.unmodifiableCollection(this.shadow$getBlockEntities().values());
    }

    @Override
    public VolumeStream<WorldChunk, BlockEntity> blockEntityStream(Vector3i min, Vector3i max, StreamOptions options) {
        VolumeStreamUtils.validateStreamArgs(Objects.requireNonNull(min, "min"), Objects.requireNonNull(max, "max"), Objects.requireNonNull(options, "options"));
        boolean shouldCarbonCopy = options.carbonCopy();
        Vector3i size = max.sub(min).add(1, 1, 1);
        ObjectArrayMutableBlockEntityBuffer backingVolume = shouldCarbonCopy ? new ObjectArrayMutableBlockEntityBuffer(min, size) : null;
        return VolumeStreamUtils.generateStream(options, this, (LevelChunk)this, this::impl$getBlockEntitiesStream, VolumeStreamUtils.getBlockEntityOrCloneToBackingVolume(shouldCarbonCopy, backingVolume, this.level), (key, biome) -> key, (blockPos, world) -> {
            @Nullable net.minecraft.world.level.block.entity.BlockEntity tileEntity = shouldCarbonCopy ? (net.minecraft.world.level.block.entity.BlockEntity)backingVolume.blockEntity(blockPos.getX(), blockPos.getY(), blockPos.getZ()).orElse(null) : ((LevelReader)world).getBlockEntity(blockPos);
            return new Tuple(blockPos, (Object)tileEntity);
        });
    }

    private Stream<Map.Entry<BlockPos, net.minecraft.world.level.block.entity.BlockEntity>> impl$getBlockEntitiesStream(ChunkAccess chunk) {
        return chunk instanceof LevelChunk ? ((LevelChunk)chunk).getBlockEntities().entrySet().stream() : Stream.empty();
    }

    @Override
    public void addBlockEntity(int x, int y, int z, BlockEntity blockEntity) {
        this.world().addBlockEntity(x, y, z, blockEntity);
    }

    @Override
    public void removeBlockEntity(int x, int y, int z) {
        this.world().removeBlockEntity(x, y, z);
    }

    @Override
    public VolumeStream<WorldChunk, Biome> biomeStream(Vector3i min, Vector3i max, StreamOptions options) {
        ObjectArrayMutableBiomeBuffer backingVolume;
        VolumeStreamUtils.validateStreamArgs(Objects.requireNonNull(min, "min"), Objects.requireNonNull(max, "max"), Objects.requireNonNull(options, "options"));
        boolean shouldCarbonCopy = options.carbonCopy();
        Vector3i size = max.sub(min).add(1, 1, 1);
        if (shouldCarbonCopy) {
            Registry biomeRegistry = this.level.registryAccess().registry(Registry.BIOME_REGISTRY).map(wr -> wr).orElse(BuiltinRegistries.BIOME);
            backingVolume = new ObjectArrayMutableBiomeBuffer(min, size, VolumeStreamUtils.nativeToSpongeRegistry(biomeRegistry));
        } else {
            backingVolume = null;
        }
        return VolumeStreamUtils.generateStream(options, this, (LevelChunk)this, VolumeStreamUtils.getBiomesForChunkByPos((LevelReader)this, min, max), (pos, biome) -> {
            if (shouldCarbonCopy) {
                backingVolume.setBiome((BlockPos)pos, (net.minecraft.world.level.biome.Biome)biome);
            }
        }, (key, biome) -> key, (blockPos, world) -> {
            net.minecraft.world.level.biome.Biome biome = shouldCarbonCopy ? backingVolume.getNativeBiome(blockPos.getX(), blockPos.getY(), blockPos.getZ()) : ((LevelReader)world.world()).getBiome(blockPos);
            return new Tuple(blockPos, (Object)biome);
        });
    }

    @Override
    public Vector3i min() {
        if (this.api$blockMin == null) {
            this.api$blockMin = SpongeChunkLayout.INSTANCE.forceToWorld(this.chunkPosition());
        }
        return this.api$blockMin;
    }

    @Override
    public Vector3i max() {
        if (this.api$blockMax == null) {
            this.api$blockMax = this.min().add(SpongeChunkLayout.CHUNK_SIZE).sub(1, 1, 1);
        }
        return this.api$blockMax;
    }

    @Override
    public Vector3i size() {
        return SpongeChunkLayout.CHUNK_SIZE;
    }

    @Override
    public Collection<? extends Player> players() {
        return this.level.players().stream().filter(x -> x.inChunk && x.xChunk == this.chunkPos.x && x.zChunk == this.chunkPos.z).collect(Collectors.toList());
    }

    @Override
    public Optional<Entity> entity(UUID uuid) {
        return Arrays.stream(this.entitySections).flatMap(Collection::stream).filter(x -> x.getUUID().equals(uuid)).findAny();
    }

    @Override
    public Collection<? extends Entity> entities() {
        return (Collection)Arrays.stream(this.entitySections).flatMap(Collection::stream).collect(ImmutableList.toImmutableList());
    }

    @Override
    public <T extends Entity> Collection<? extends T> entities(Class<? extends T> entityClass, org.spongepowered.api.util.AABB box, @Nullable Predicate<? super T> predicate) {
        ArrayList entities = new ArrayList();
        this.shadow$getEntitiesOfClass(entityClass, VecHelper.toMinecraftAABB(box), entities, predicate);
        return entities;
    }

    @Override
    public Collection<? extends Entity> entities(org.spongepowered.api.util.AABB box, Predicate<? super Entity> filter) {
        ArrayList<net.minecraft.world.entity.Entity> entities = new ArrayList<net.minecraft.world.entity.Entity>();
        this.shadow$getEntities(null, VecHelper.toMinecraftAABB(box), entities, filter);
        return entities;
    }

    @Override
    public <E extends Entity> E createEntity(EntityType<E> type, Vector3d position) throws IllegalArgumentException, IllegalStateException {
        this.api$checkPositionInChunk(position);
        return ((LevelBridge)this.level).bridge$createEntity(type, position, false);
    }

    @Override
    public <E extends Entity> E createEntityNaturally(EntityType<E> type, Vector3d position) throws IllegalArgumentException, IllegalStateException {
        this.api$checkPositionInChunk(position);
        return ((LevelBridge)this.level).bridge$createEntity(type, position, true);
    }

    @Override
    public Optional<Entity> createEntity(DataContainer container) {
        return Optional.ofNullable(((LevelBridge)this.level).bridge$createEntity(container, null, position -> VecHelper.inBounds(position, this.min(), this.max())));
    }

    @Override
    public Optional<Entity> createEntity(DataContainer container, Vector3d position) {
        this.api$checkPositionInChunk(position);
        return Optional.ofNullable(((LevelBridge)this.level).bridge$createEntity(container, position, null));
    }

    @Override
    public boolean spawnEntity(Entity entity) {
        return ((LevelChunkBridge)((Object)this)).bridge$spawnEntity(entity);
    }

    @Override
    public Collection<Entity> spawnEntities(Iterable<? extends Entity> entities) {
        return EntityUtil.spawnEntities(entities, x -> this.api$isInBounds(x.position()), entity -> ((LevelChunkBridge)((Object)this)).bridge$spawnEntity((Entity)entity));
    }

    @Override
    public boolean setBlock(int x, int y, int z, org.spongepowered.api.block.BlockState blockState, BlockChangeFlag flag) {
        this.api$checkPositionInChunk(x, y, z);
        return ((WorldLike)this.level).setBlock(x, y, z, blockState, flag);
    }

    private void api$checkPositionInChunk(int x, int y, int z) {
        if (!VecHelper.inBounds((double)x, (double)y, (double)z, this.min(), this.max())) {
            throw new IllegalArgumentException("Supplied bounds are not within this chunk.");
        }
    }

    private void api$checkPositionInChunk(Vector3d position) {
        if (!this.api$isInBounds(position)) {
            throw new IllegalArgumentException("Supplied bounds are not within this chunk.");
        }
    }

    private boolean api$isInBounds(Vector3d position) {
        return VecHelper.inBounds(position, this.min(), this.max());
    }

    @Override
    public ServerLocation impl$dataholder(int x, int y, int z) {
        this.api$checkPositionInChunk(x, y, z);
        if (this.level instanceof ServerWorld) {
            return (ServerLocation)((ServerWorld)this.level).location(x, y, z);
        }
        throw new MissingImplementationException("LevelChunk", "impl$dataholder");
    }
}

