/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.client;

import com.mojang.serialization.DynamicOps;
import java.nio.file.Path;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.main.GameConfig;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.RegistryReadOps;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.thread.ReentrantBlockableEventLoop;
import net.minecraft.world.level.DataPackConfig;
import net.minecraft.world.level.LevelSettings;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.WorldData;
import org.spongepowered.api.datapack.DataPackTypes;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.applaunch.config.core.ConfigHandle;
import org.spongepowered.common.bridge.client.MinecraftBridge;
import org.spongepowered.common.client.SpongeClient;
import org.spongepowered.common.datapack.SpongeDataPackManager;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.launch.Launch;
import org.spongepowered.common.launch.Lifecycle;
import org.spongepowered.common.server.BootstrapProperties;

@Mixin(value={Minecraft.class})
public abstract class MinecraftMixin
extends ReentrantBlockableEventLoop<Runnable>
implements MinecraftBridge,
SpongeClient {
    @Shadow
    private Thread gameThread;
    @Shadow
    @Nullable
    private IntegratedServer singleplayerServer;
    private IntegratedServer impl$temporaryIntegratedServer;

    public MinecraftMixin(String param0) {
        super(param0);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void impl$setClientOnGame(GameConfig gameConfig, CallbackInfo ci) {
        SpongeCommon.game().setClient(this);
    }

    @Inject(method={"run"}, at={@At(value="HEAD")})
    private void impl$setThreadOnClientPhaseTracker(CallbackInfo ci) {
        try {
            PhaseTracker.CLIENT.setThread(this.gameThread);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Could not initialize the client PhaseTracker!");
        }
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void impl$callStartedEngineAndLoadedGame(CallbackInfo ci) {
        ConfigHandle.setSaveSuppressed(false);
        Lifecycle lifecycle = ((Launch)Launch.instance()).lifecycle();
        lifecycle.callStartedEngineEvent(this);
        lifecycle.callLoadedGameEvent();
    }

    @Redirect(method={"runTick"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;runAllTasks()V"))
    private void impl$tickClientScheduler(Minecraft minecraft) {
        this.scheduler().tick();
        this.runAllTasks();
    }

    @Override
    public IntegratedServer bridge$getTemporaryIntegratedServer() {
        return this.impl$temporaryIntegratedServer;
    }

    @Override
    public void bridge$setTemporaryIntegratedServer(IntegratedServer server) {
        this.impl$temporaryIntegratedServer = server;
    }

    @Inject(method={"destroy"}, at={@At(value="HEAD")})
    private void impl$callStoppingEngineEvent(CallbackInfo ci) {
        ((Launch)Launch.instance()).lifecycle().callStoppingEngineEvent(this);
    }

    @Redirect(method={"clearLevel(Lnet/minecraft/client/gui/screens/Screen;)V"}, at=@At(value="FIELD", target="Lnet/minecraft/client/Minecraft;singleplayerServer:Lnet/minecraft/client/server/IntegratedServer;", opcode=181))
    private void impl$storeTemporaryServerRef(Minecraft minecraft, IntegratedServer server) {
        ((MinecraftBridge)minecraft).bridge$setTemporaryIntegratedServer(this.singleplayerServer);
        this.singleplayerServer = null;
    }

    @Inject(method={"clearLevel(Lnet/minecraft/client/gui/screens/Screen;)V"}, at={@At(value="TAIL")})
    private void impl$nullServerRefAndPhaseTracker(Screen screenIn, CallbackInfo ci) {
        this.bridge$setTemporaryIntegratedServer(null);
        try {
            PhaseTracker.SERVER.setThread(null);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    @Inject(method={"close"}, at={@At(value="INVOKE", target="Lnet/minecraft/Util;shutdownExecutors()V")})
    private void impl$callStoppedGame(CallbackInfo ci) {
        ((Launch)Launch.instance()).lifecycle().callStoppedGameEvent();
    }

    @Redirect(method={"loadWorldData"}, at=@At(value="INVOKE", target="Lnet/minecraft/resources/RegistryReadOps;create(Lcom/mojang/serialization/DynamicOps;Lnet/minecraft/server/packs/resources/ResourceManager;Lnet/minecraft/core/RegistryAccess$RegistryHolder;)Lnet/minecraft/resources/RegistryReadOps;"))
    private static RegistryReadOps impl$setWorldSettingsAdapter(DynamicOps p_244335_0_, ResourceManager p_244335_1_, RegistryAccess.RegistryHolder p_244335_2_) {
        RegistryReadOps worldSettingsAdapter = RegistryReadOps.create((DynamicOps)p_244335_0_, (ResourceManager)p_244335_1_, (RegistryAccess.RegistryHolder)p_244335_2_);
        BootstrapProperties.worldSettingsAdapter(worldSettingsAdapter);
        return worldSettingsAdapter;
    }

    @Redirect(method={"loadWorldData"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/storage/LevelStorageSource$LevelStorageAccess;getDataTag(Lcom/mojang/serialization/DynamicOps;Lnet/minecraft/world/level/DataPackConfig;)Lnet/minecraft/world/level/storage/WorldData;"))
    private static WorldData impl$serializeDelayedDataPackOnLoadAndSetBootstrapProperties(LevelStorageSource.LevelStorageAccess levelSave, DynamicOps<Tag> p_237284_1_, DataPackConfig p_237284_2_, LevelStorageSource.LevelStorageAccess p_238181_0_, RegistryAccess.RegistryHolder p_238181_1_) {
        SpongeDataPackManager.INSTANCE.serializeDelayedDataPack(DataPackTypes.WORLD);
        WorldData saveData = levelSave.getDataTag(p_237284_1_, p_237284_2_);
        BootstrapProperties.init(saveData.worldGenSettings(), saveData.getGameType(), saveData.getDifficulty(), true, saveData.isHardcore(), saveData.getAllowCommands(), 10, (RegistryAccess)p_238181_1_);
        return saveData;
    }

    @Inject(method={"createLevel"}, at={@At(value="HEAD")})
    private void impl$setBootstrapProperties(String levelName, LevelSettings settings, RegistryAccess.RegistryHolder registries, WorldGenSettings dimensionGeneratorSettings, CallbackInfo ci) {
        BootstrapProperties.init(dimensionGeneratorSettings, settings.gameType(), settings.difficulty(), true, settings.hardcore(), settings.allowCommands(), 10, (RegistryAccess)registries);
        BootstrapProperties.setIsNewLevel(true);
    }

    @Redirect(method={"makeServerStem"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/storage/LevelStorageSource$LevelStorageAccess;getLevelPath(Lnet/minecraft/world/level/storage/LevelResource;)Ljava/nio/file/Path;"))
    private Path impl$configurePackRepository(LevelStorageSource.LevelStorageAccess levelSave, LevelResource folderName) {
        Path datapackDir = levelSave.getLevelPath(folderName);
        ((Launch)Launch.instance()).lifecycle().callRegisterDataPackValueEvent(datapackDir);
        return datapackDir;
    }
}

