/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.commands;

import com.mojang.brigadier.ResultConsumer;
import java.util.function.Supplier;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandCause;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContext;
import org.spongepowered.api.event.EventContextKey;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.accessor.commands.CommandSourceStackAccessor;
import org.spongepowered.common.accessor.world.entity.EntityAccessor;
import org.spongepowered.common.bridge.commands.CommandSourceBridge;
import org.spongepowered.common.bridge.commands.CommandSourceStackBridge;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.service.server.permission.SpongePermissions;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.math.vector.Vector3d;

@Mixin(value={CommandSourceStack.class})
public abstract class CommandSourceStackMixin
implements CommandSourceStackBridge {
    private static final String PROTECTED_CTOR = "(Lnet/minecraft/commands/CommandSource;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/Vec2;Lnet/minecraft/server/level/ServerLevel;ILjava/lang/String;Lnet/minecraft/network/chat/Component;Lnet/minecraft/server/MinecraftServer;Lnet/minecraft/world/entity/Entity;ZLcom/mojang/brigadier/ResultConsumer;Lnet/minecraft/commands/arguments/EntityAnchorArgument$Anchor;)";
    private static final String PROTECTED_CTOR_METHOD = "<init>(Lnet/minecraft/commands/CommandSource;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/Vec2;Lnet/minecraft/server/level/ServerLevel;ILjava/lang/String;Lnet/minecraft/network/chat/Component;Lnet/minecraft/server/MinecraftServer;Lnet/minecraft/world/entity/Entity;ZLcom/mojang/brigadier/ResultConsumer;Lnet/minecraft/commands/arguments/EntityAnchorArgument$Anchor;)V";
    @Shadow
    @Final
    private CommandSource source;
    @Shadow
    @Final
    @Mutable
    private Vec3 worldPosition;
    @Shadow
    @Final
    @Mutable
    private Vec2 rotation;
    @Shadow
    @Final
    @Mutable
    private ServerLevel level;
    @Shadow
    @Final
    @Mutable
    private int permissionLevel;
    @Shadow
    @Final
    private Component displayName;
    @Shadow
    @Final
    private String textName;
    @Shadow
    @Final
    private @Nullable Entity entity;
    @Shadow
    @Final
    private MinecraftServer server;
    @Shadow
    @Final
    private boolean silent;
    @Shadow
    @Final
    private ResultConsumer<CommandSourceStack> consumer;
    @Shadow
    @Final
    private EntityAnchorArgument.Anchor anchor;
    private Cause impl$cause;
    private @Nullable Supplier<String> impl$potentialPermissionNode = null;

    @Inject(method={"<init>(Lnet/minecraft/commands/CommandSource;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/Vec2;Lnet/minecraft/server/level/ServerLevel;ILjava/lang/String;Lnet/minecraft/network/chat/Component;Lnet/minecraft/server/MinecraftServer;Lnet/minecraft/world/entity/Entity;ZLcom/mojang/brigadier/ResultConsumer;Lnet/minecraft/commands/arguments/EntityAnchorArgument$Anchor;)V"}, at={@At(value="RETURN")})
    private void impl$setCauseOnConstruction(CommandSource p_i49553_1_, Vec3 p_i49553_2_, Vec2 p_i49553_3_, ServerLevel p_i49553_4_, int p_i49553_5_, String p_i49553_6_, Component p_i49553_7_, MinecraftServer p_i49553_8_, @Nullable Entity p_i49553_9_, boolean p_i49553_10_, ResultConsumer<CommandSourceStack> p_i49553_11_, EntityAnchorArgument.Anchor p_i49553_12_, CallbackInfo ci) {
        this.impl$cause = PhaseTracker.getCauseStackManager().currentCause();
        EventContext context = this.impl$cause.context();
        context.get(EventContextKeys.LOCATION).ifPresent(x -> {
            this.worldPosition = VecHelper.toVanillaVector3d(x.position());
            this.level = (ServerLevel)x.world();
        });
        context.get(EventContextKeys.ROTATION).ifPresent(x -> {
            this.rotation = new Vec2((float)x.x(), (float)x.y());
        });
        context.get(EventContextKeys.SUBJECT).ifPresent(x -> {
            if (x instanceof EntityAccessor) {
                this.permissionLevel = ((EntityAccessor)((Object)x)).invoker$getPermissionLevel();
            } else if (x instanceof MinecraftServer && !((MinecraftServer)x).isSingleplayer()) {
                this.permissionLevel = 4;
            }
        });
    }

    @Inject(method={"withEntity", "withPosition", "withRotation(Lnet/minecraft/world/phys/Vec2;)Lnet/minecraft/commands/CommandSourceStack;", "withCallback(Lcom/mojang/brigadier/ResultConsumer;)Lnet/minecraft/commands/CommandSourceStack;", "withSuppressedOutput", "withPermission", "withMaximumPermission", "withAnchor", "withLevel"}, at={@At(value="RETURN")})
    private void impl$copyPermissionOnCopy(CallbackInfoReturnable<CommandSourceStack> cir) {
        if (cir.getReturnValue() != this) {
            CommandSourceStackBridge commandSourceStackBridge = (CommandSourceStackBridge)cir.getReturnValue();
            commandSourceStackBridge.bridge$setPotentialPermissionNode(this.impl$potentialPermissionNode);
            commandSourceStackBridge.bridge$setCause(this.impl$cause);
        }
    }

    @Override
    public CommandCause bridge$withCurrentCause() {
        return (CommandCause)CommandSourceStackAccessor.invoker$new(this.source, this.worldPosition, this.rotation, this.level, this.permissionLevel, this.textName, this.displayName, this.server, this.entity, this.silent, this.consumer, this.anchor);
    }

    @Inject(method={"withLevel"}, at={@At(value="RETURN")})
    private void impl$updateCauseOnWithWorld(ServerLevel serverWorld, CallbackInfoReturnable<CommandSourceStack> cir) {
        if (cir.getReturnValue() != this) {
            ServerLocation location = this.impl$cause.context().get(EventContextKeys.LOCATION).map(x -> ServerLocation.of((ServerWorld)serverWorld, x.position())).orElseGet(() -> ServerLocation.of((ServerWorld)serverWorld, VecHelper.toVector3d(((CommandSourceStack)cir.getReturnValue()).getPosition())));
            ((CommandSourceStackBridge)cir.getReturnValue()).bridge$setCause(this.impl$applyToCause(EventContextKeys.LOCATION, location));
        }
    }

    @Inject(method={"withPosition"}, at={@At(value="RETURN")})
    private void impl$updateCauseOnWithPosition(Vec3 pos, CallbackInfoReturnable<CommandSourceStack> cir) {
        if (cir.getReturnValue() != this) {
            Vector3d position = VecHelper.toVector3d(pos);
            ServerLocation location = this.impl$cause.context().get(EventContextKeys.LOCATION).map(x -> ServerLocation.of((ServerWorld)x.world(), position)).orElseGet(() -> ServerLocation.of((ServerWorld)((CommandSourceStack)cir.getReturnValue()).getLevel(), position));
            ((CommandSourceStackBridge)cir.getReturnValue()).bridge$setCause(this.impl$applyToCause(EventContextKeys.LOCATION, location));
        }
    }

    @Inject(method={"withRotation(Lnet/minecraft/world/phys/Vec2;)Lnet/minecraft/commands/CommandSourceStack;"}, at={@At(value="RETURN")})
    private void impl$updateCauseOnWithRotation(Vec2 rotation, CallbackInfoReturnable<CommandSourceStack> cir) {
        if (cir.getReturnValue() != this) {
            Vector3d rot = new Vector3d(rotation.x, rotation.y, 0.0f);
            ((CommandSourceStackBridge)cir.getReturnValue()).bridge$setCause(this.impl$applyToCause(EventContextKeys.ROTATION, rot));
        }
    }

    @Inject(method={"hasPermission"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$checkPermission(int opLevel, CallbackInfoReturnable<Boolean> cir) {
        if (Sponge.isServerAvailable() && this.impl$potentialPermissionNode != null) {
            String perm = this.impl$potentialPermissionNode.get();
            SpongePermissions.registerPermission(perm, opLevel);
            cir.setReturnValue((Object)((CommandCause)((Object)this)).hasPermission(perm));
        }
    }

    @Override
    public void bridge$setPotentialPermissionNode(@Nullable Supplier<String> permission) {
        this.impl$potentialPermissionNode = permission;
    }

    @Override
    public void bridge$setCause(Cause cause) {
        this.impl$cause = cause;
    }

    @Override
    public Cause bridge$getCause() {
        return this.impl$cause;
    }

    @Override
    public CommandSource bridge$getCommandSource() {
        return this.source;
    }

    @Override
    public void bridge$updateFrameFromCommandSource(CauseStackManager.StackFrame frame) {
        ((CommandSourceBridge)this.source).bridge$addToCauseStack(frame);
    }

    @Override
    public CommandCause bridge$asCommandCause() {
        return (CommandCause)((Object)this);
    }

    private <T> Cause impl$applyToCause(EventContextKey<T> key, T value) {
        EventContext.Builder builder = EventContext.builder();
        this.impl$cause.context().asMap().forEach((k, v) -> {
            if (!k.equals(key)) {
                builder.add(k, v);
            }
        });
        builder.add(key, value);
        return Cause.builder().from(this.impl$cause).build(builder.build());
    }
}

