/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.server.level;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.ImposterProtoChunk;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.storage.ChunkSerializer;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.world.chunk.ChunkEvent;
import org.spongepowered.api.util.Direction;
import org.spongepowered.api.world.SerializationBehavior;
import org.spongepowered.api.world.chunk.WorldChunk;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.accessor.server.level.ServerChunkCacheAccessor;
import org.spongepowered.common.bridge.world.DistanceManagerBridge;
import org.spongepowered.common.bridge.world.level.chunk.LevelChunkBridge;
import org.spongepowered.common.bridge.world.level.storage.PrimaryLevelDataBridge;
import org.spongepowered.common.bridge.world.server.ChunkMapBridge;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.util.DirectionUtil;
import org.spongepowered.math.vector.Vector3i;

@Mixin(value={ChunkMap.class})
public abstract class ChunkMapMixin
implements ChunkMapBridge {
    @Shadow
    @Final
    private ServerLevel level;

    @Override
    public DistanceManagerBridge bridge$distanceManager() {
        return (DistanceManagerBridge)((ServerChunkCacheAccessor)this.level.getChunkSource()).accessor$distanceManager();
    }

    @Redirect(method={"save"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/ai/village/poi/PoiManager;flush(Lnet/minecraft/world/level/ChunkPos;)V"))
    private void impl$useSerializationBehaviorForPOI(PoiManager pointOfInterestManager, ChunkPos p_219112_1_) {
        PrimaryLevelDataBridge infoBridge = (PrimaryLevelDataBridge)this.level.getLevelData();
        SerializationBehavior serializationBehavior = infoBridge.bridge$serializationBehavior().orElse(SerializationBehavior.AUTOMATIC);
        if (serializationBehavior == SerializationBehavior.AUTOMATIC || serializationBehavior == SerializationBehavior.MANUAL) {
            pointOfInterestManager.flush(p_219112_1_);
        }
    }

    @Redirect(method={"save"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/chunk/storage/ChunkSerializer;write(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/level/chunk/ChunkAccess;)Lnet/minecraft/nbt/CompoundTag;"))
    private CompoundTag impl$useSerializationBehaviorForChunkSave(ServerLevel worldIn, ChunkAccess chunkIn) {
        PrimaryLevelDataBridge infoBridge = (PrimaryLevelDataBridge)this.level.getLevelData();
        SerializationBehavior serializationBehavior = infoBridge.bridge$serializationBehavior().orElse(SerializationBehavior.AUTOMATIC);
        if (serializationBehavior == SerializationBehavior.AUTOMATIC || serializationBehavior == SerializationBehavior.MANUAL) {
            return ChunkSerializer.write((ServerLevel)worldIn, (ChunkAccess)chunkIn);
        }
        return null;
    }

    @Redirect(method={"save"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ChunkMap;write(Lnet/minecraft/world/level/ChunkPos;Lnet/minecraft/nbt/CompoundTag;)V"))
    private void impl$doNotWriteIfWeHaveNoData(ChunkMap chunkManager, ChunkPos pos, CompoundTag compound) {
        if (compound == null) {
            return;
        }
        chunkManager.write(pos, compound);
    }

    @Redirect(method={"lambda$scheduleUnload$10"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;unload(Lnet/minecraft/world/level/chunk/LevelChunk;)V"), slice=@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/server/level/ChunkMap;save(Lnet/minecraft/world/level/chunk/ChunkAccess;)Z")))
    private void impl$onSetUnloaded(ServerLevel level, LevelChunk chunk) {
        Vector3i chunkPos = new Vector3i(chunk.getPos().x, 0, chunk.getPos().z);
        if (ShouldFire.CHUNK_EVENT_UNLOAD_PRE) {
            ChunkEvent.Unload.Pre pre = SpongeEventFactory.createChunkEventUnloadPre(PhaseTracker.getInstance().currentCause(), (WorldChunk)chunk, chunkPos, (ResourceKey)this.level.dimension().location());
            SpongeCommon.post(pre);
        }
        level.unload(chunk);
        for (Direction dir : Constants.Chunk.CARDINAL_DIRECTIONS) {
            Vector3i neighborPos = chunkPos.add(dir.asBlockOffset());
            ChunkAccess neighbor = this.level.getChunk(neighborPos.x(), neighborPos.z(), ChunkStatus.EMPTY, false);
            if (!(neighbor instanceof LevelChunk)) continue;
            int index = DirectionUtil.directionToIndex(dir);
            int oppositeIndex = DirectionUtil.directionToIndex(dir.opposite());
            ((LevelChunkBridge)chunk).bridge$setNeighborChunk(index, null);
            ((LevelChunkBridge)neighbor).bridge$setNeighborChunk(oppositeIndex, null);
        }
        if (ShouldFire.CHUNK_EVENT_UNLOAD_POST) {
            ChunkEvent.Unload.Post post = SpongeEventFactory.createChunkEventUnloadPost(PhaseTracker.getInstance().currentCause(), chunkPos, (ResourceKey)this.level.dimension().location());
            SpongeCommon.post(post);
        }
    }

    @Inject(method={"save"}, at={@At(value="RETURN")})
    private void impl$onSaved(ChunkAccess var1, CallbackInfoReturnable<Boolean> cir) {
        if (ShouldFire.CHUNK_EVENT_SAVE_POST) {
            Vector3i chunkPos = new Vector3i(var1.getPos().x, 0, var1.getPos().z);
            ChunkEvent.Save.Post postSave = SpongeEventFactory.createChunkEventSavePost(PhaseTracker.getInstance().currentCause(), chunkPos, (ResourceKey)this.level.dimension().location());
            SpongeCommon.post(postSave);
        }
    }

    @Inject(method={"save"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$onSave(ChunkAccess var1, CallbackInfoReturnable<Boolean> cir) {
        if (var1 instanceof WorldChunk && ShouldFire.CHUNK_EVENT_SAVE_PRE) {
            Vector3i chunkPos = new Vector3i(var1.getPos().x, 0, var1.getPos().z);
            ChunkEvent.Save.Pre postSave = SpongeEventFactory.createChunkEventSavePre(PhaseTracker.getInstance().currentCause(), (WorldChunk)var1, chunkPos, (ResourceKey)this.level.dimension().location());
            SpongeCommon.post(postSave);
            if (postSave.isCancelled()) {
                cir.setReturnValue((Object)false);
            }
        }
    }

    @Redirect(method={"*"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/chunk/LevelChunk;setLoaded(Z)V"), slice=@Slice(from=@At(value="INVOKE", remap=false, target="Lit/unimi/dsi/fastutil/longs/LongSet;add(J)Z"), to=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;addAllPendingBlockEntities(Ljava/util/Collection;)V")))
    private void impl$onLoad(LevelChunk levelChunk, boolean loaded) {
        levelChunk.setLoaded(true);
        Vector3i chunkPos = new Vector3i(levelChunk.getPos().x, 0, levelChunk.getPos().z);
        if (ShouldFire.CHUNK_EVENT_LOAD) {
            ChunkEvent.Load loadEvent = SpongeEventFactory.createChunkEventLoad(PhaseTracker.getInstance().currentCause(), (WorldChunk)levelChunk, chunkPos, (ResourceKey)this.level.dimension().location());
            SpongeCommon.post(loadEvent);
        }
        for (Direction dir : Constants.Chunk.CARDINAL_DIRECTIONS) {
            Vector3i neighborPos = chunkPos.add(dir.asBlockOffset());
            ChunkAccess neighbor = this.level.getChunk(neighborPos.x(), neighborPos.z(), ChunkStatus.EMPTY, false);
            if (neighbor instanceof ImposterProtoChunk) {
                neighbor = ((ImposterProtoChunk)neighbor).getWrapped();
            }
            if (!(neighbor instanceof LevelChunk)) continue;
            int index = DirectionUtil.directionToIndex(dir);
            int oppositeIndex = DirectionUtil.directionToIndex(dir.opposite());
            ((LevelChunkBridge)levelChunk).bridge$setNeighborChunk(index, (LevelChunk)neighbor);
            ((LevelChunkBridge)neighbor).bridge$setNeighborChunk(oppositeIndex, levelChunk);
        }
    }
}

