/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.server.level;

import java.util.Set;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.text.Component;
import net.minecraft.network.protocol.game.ClientboundBossEventPacket;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.BossEvent;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.mixin.core.world.BossEventMixin;

@Mixin(value={ServerBossEvent.class})
public abstract class ServerBossEventMixin
extends BossEventMixin
implements BossBar.Listener {
    private static final float EPSILON = 0.01f;
    private float impl$lastSentProgress = 0.0f;
    @Shadow
    @Final
    private Set<ServerPlayer> players;
    @Shadow
    private boolean visible;

    @Shadow
    protected abstract void broadcast(ClientboundBossEventPacket.Operation var1);

    @Override
    public void bridge$setAdventure(BossBar adventure) {
        BossBar oldAdventure = this.impl$adventure;
        super.bridge$setAdventure(adventure);
        if (oldAdventure != adventure) {
            if (oldAdventure != null) {
                oldAdventure.removeListener((BossBar.Listener)this);
            }
            adventure.addListener((BossBar.Listener)this);
            this.name = null;
            this.percent = Float.MIN_VALUE;
            this.color = null;
            this.overlay = null;
        }
    }

    @Override
    public void bridge$replacePlayer(ServerPlayer oldPlayer, ServerPlayer newPlayer) {
        super.bridge$replacePlayer(oldPlayer, newPlayer);
        if (this.players.remove(oldPlayer)) {
            this.players.add(newPlayer);
        }
    }

    @Inject(method={"setDarkenScreen"}, at={@At(value="HEAD")})
    private void impl$forceDarkenSkyUpdate(boolean darkenSky, CallbackInfoReturnable<BossEvent> ci) {
        this.darkenScreen = !darkenSky;
    }

    @Inject(method={"setPlayBossMusic"}, at={@At(value="HEAD")})
    private void forcePlayEndBossMusicUpdate(boolean endBossMusic, CallbackInfoReturnable<BossEvent> ci) {
        this.playBossMusic = !endBossMusic;
    }

    @Inject(method={"setCreateWorldFog"}, at={@At(value="HEAD")})
    private void forceCreateFogUpdate(boolean createFog, CallbackInfoReturnable<BossEvent> ci) {
        this.createWorldFog = !createFog;
    }

    @Redirect(method={"setPercent", "setColor", "setOverlay", "setDarkenScreen", "setPlayBossMusic", "setCreateWorldFog", "setName"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerBossEvent;broadcast(Lnet/minecraft/network/protocol/game/ClientboundBossEventPacket$Operation;)V"))
    private void redirectUpdatePacket(ServerBossEvent $this, ClientboundBossEventPacket.Operation op) {
    }

    public void bossBarNameChanged(BossBar bar, Component oldName, Component newName) {
        this.broadcast(ClientboundBossEventPacket.Operation.UPDATE_NAME);
    }

    public void bossBarProgressChanged(BossBar bar, float oldProgress, float newProgress) {
        if (Math.abs(newProgress - this.impl$lastSentProgress) > 0.01f) {
            this.impl$lastSentProgress = newProgress;
            this.broadcast(ClientboundBossEventPacket.Operation.UPDATE_PCT);
        }
    }

    public void bossBarColorChanged(BossBar bar, BossBar.Color oldColor, BossBar.Color newColor) {
        this.broadcast(ClientboundBossEventPacket.Operation.UPDATE_STYLE);
    }

    public void bossBarOverlayChanged(BossBar bar, BossBar.Overlay oldOverlay, BossBar.Overlay newOverlay) {
        this.broadcast(ClientboundBossEventPacket.Operation.UPDATE_STYLE);
    }

    public void bossBarFlagsChanged(BossBar bar, Set<BossBar.Flag> flagsAdded, Set<BossBar.Flag> flagsRemoved) {
        this.broadcast(ClientboundBossEventPacket.Operation.UPDATE_PROPERTIES);
    }

    @Inject(method={"addPlayer"}, at={@At(value="TAIL")})
    private void impl$addPlayer(ServerPlayer player, CallbackInfo ci) {
        if (!this.players.isEmpty() && this.visible) {
            SpongeAdventure.registerBossBar((ServerBossEvent)this);
        }
    }

    @Inject(method={"removePlayer"}, at={@At(value="TAIL")})
    private void impl$removePlayer(ServerPlayer player, CallbackInfo ci) {
        if (this.players.isEmpty()) {
            SpongeAdventure.unregisterBossBar((ServerBossEvent)this);
        }
    }

    @Inject(method={"removeAllPlayers"}, at={@At(value="HEAD")})
    private void impl$removeAllPlayers(CallbackInfo ci) {
        SpongeAdventure.unregisterBossBar((ServerBossEvent)this);
    }

    @Inject(method={"setVisible"}, at={@At(value="HEAD")})
    private void impl$setVisible(boolean visible, CallbackInfo ci) {
        if (!this.players.isEmpty()) {
            if (visible) {
                SpongeAdventure.registerBossBar((ServerBossEvent)this);
            } else {
                SpongeAdventure.unregisterBossBar((ServerBossEvent)this);
            }
        }
    }
}

