/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.entity.decoration;

import java.util.ArrayList;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.decoration.HangingEntity;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.entity.damage.DamageFunction;
import org.spongepowered.api.event.entity.AttackEntityEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.mixin.core.world.entity.EntityMixin;

@Mixin(value={HangingEntity.class})
public abstract class HangingEntityMixin
extends EntityMixin {
    private boolean impl$ignorePhysics = false;

    @Shadow
    public abstract boolean shadow$survives();

    @Redirect(method={"tick()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/decoration/HangingEntity;survives()Z"))
    private boolean impl$checkIfOnValidSurfaceAndIgnoresPhysics(HangingEntity entityHanging) {
        return this.shadow$survives() && !this.impl$ignorePhysics;
    }

    @Inject(method={"hurt"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/decoration/HangingEntity;remove()V")}, cancellable=true)
    private void impl$postEventOnAttackEntityFrom(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(source);
            AttackEntityEvent event = SpongeEventFactory.createAttackEntityEvent(frame.currentCause(), (Entity)((Object)this), new ArrayList<DamageFunction>(), 0.0f, amount);
            SpongeCommon.post(event);
            if (event.isCancelled()) {
                cir.setReturnValue((Object)true);
            }
        }
    }
}

