/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.entity.vehicle;

import java.util.ArrayList;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.entity.vehicle.minecart.MinecartLike;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.entity.damage.DamageFunction;
import org.spongepowered.api.event.entity.AttackEntityEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.data.SpongeDataHolderBridge;
import org.spongepowered.common.bridge.world.entity.vehicle.AbstractMinecartBridge;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.mixin.core.world.entity.EntityMixin;
import org.spongepowered.math.vector.Vector3d;

@Mixin(value={AbstractMinecart.class})
public abstract class AbstractMinecartMixin
extends EntityMixin
implements AbstractMinecartBridge {
    protected double impl$maxSpeed = 0.4;
    private boolean impl$slowWhenEmpty = true;
    private Vector3d impl$airborneMod = new Vector3d((double)0.95f, (double)0.95f, (double)0.95f);
    private Vector3d impl$derailedMod = new Vector3d(0.5, 0.5, 0.5);

    @Overwrite
    protected double getMaxSpeed() {
        return this.impl$maxSpeed;
    }

    @Redirect(method={"comeOffTrack"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/phys/Vec3;scale(D)Lnet/minecraft/world/phys/Vec3;"), slice=@Slice(from=@At(value="FIELD", target="Lnet/minecraft/world/phys/Vec3;z:D"), to=@At(value="FIELD", target="Lnet/minecraft/world/entity/MoverType;SELF:Lnet/minecraft/world/entity/MoverType;")), expect=1, require=1)
    private Vec3 impl$applyDerailedModifierOnGround(Vec3 vec3d, double factor) {
        return vec3d.multiply(this.impl$derailedMod.x(), this.impl$derailedMod.y(), this.impl$derailedMod.z());
    }

    @Redirect(method={"comeOffTrack"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/phys/Vec3;scale(D)Lnet/minecraft/world/phys/Vec3;"), slice=@Slice(from=@At(value="FIELD", target="Lnet/minecraft/world/entity/MoverType;SELF:Lnet/minecraft/world/entity/MoverType;"), to=@At(value="TAIL")), expect=1, require=1)
    private Vec3 impl$applyDerailedModifierInAir(Vec3 vec3d, double factor) {
        return vec3d.multiply(this.impl$airborneMod.x(), this.impl$airborneMod.y(), this.impl$airborneMod.z());
    }

    @Redirect(method={"applyNaturalSlowdown"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/vehicle/AbstractMinecart;isVehicle()Z"))
    private boolean impl$applyDragIfEmpty(AbstractMinecart self) {
        return !this.impl$slowWhenEmpty || this.shadow$isVehicle();
    }

    @Inject(method={"hurt"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/vehicle/AbstractMinecart;ejectPassengers()V")}, cancellable=true)
    private void impl$postOnAttackEntityFrom(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(this);
            frame.pushCause(source);
            AttackEntityEvent event = SpongeEventFactory.createAttackEntityEvent(frame.currentCause(), (MinecartLike)((Object)this), new ArrayList<DamageFunction>(), 0.0f, amount);
            SpongeCommon.post(event);
            if (event.isCancelled()) {
                cir.setReturnValue((Object)true);
            }
        }
    }

    @Override
    public double bridge$getMaxSpeed() {
        return this.impl$maxSpeed;
    }

    @Override
    public void bridge$setMaxSpeed(double impl$maxSpeed) {
        this.impl$maxSpeed = impl$maxSpeed;
        if (impl$maxSpeed == 0.4) {
            ((SpongeDataHolderBridge)((Object)this)).bridge$remove(Keys.POTENTIAL_MAX_SPEED);
        } else {
            ((SpongeDataHolderBridge)((Object)this)).bridge$offer(Keys.POTENTIAL_MAX_SPEED, impl$maxSpeed);
        }
    }

    @Override
    public boolean bridge$getSlowWhenEmpty() {
        return this.impl$slowWhenEmpty;
    }

    @Override
    public void bridge$setSlowWhenEmpty(boolean impl$slowWhenEmpty) {
        this.impl$slowWhenEmpty = impl$slowWhenEmpty;
        if (impl$slowWhenEmpty) {
            ((SpongeDataHolderBridge)((Object)this)).bridge$remove(Keys.SLOWS_UNOCCUPIED);
        } else {
            ((SpongeDataHolderBridge)((Object)this)).bridge$offer(Keys.SLOWS_UNOCCUPIED, false);
        }
    }

    @Override
    public Vector3d bridge$getAirborneMod() {
        return this.impl$airborneMod;
    }

    @Override
    public void bridge$setAirborneMod(Vector3d impl$airborneMod) {
        this.impl$airborneMod = impl$airborneMod;
        if (impl$airborneMod.equals((Object)new Vector3d((double)0.95f, (double)0.95f, (double)0.95f))) {
            ((SpongeDataHolderBridge)((Object)this)).bridge$remove(Keys.AIRBORNE_VELOCITY_MODIFIER);
        } else {
            ((SpongeDataHolderBridge)((Object)this)).bridge$offer(Keys.AIRBORNE_VELOCITY_MODIFIER, impl$airborneMod);
        }
    }

    @Override
    public Vector3d bridge$getDerailedMod() {
        return this.impl$derailedMod;
    }

    @Override
    public void bridge$setDerailedMod(Vector3d impl$derailedMod) {
        this.impl$derailedMod = impl$derailedMod;
        if (impl$derailedMod.equals((Object)new Vector3d(0.5, 0.5, 0.5))) {
            ((SpongeDataHolderBridge)((Object)this)).bridge$remove(Keys.DERAILED_VELOCITY_MODIFIER);
        } else {
            ((SpongeDataHolderBridge)((Object)this)).bridge$offer(Keys.DERAILED_VELOCITY_MODIFIER, impl$derailedMod);
        }
    }
}

