/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.level.block.entity;

import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.entity.BrewingStandBlockEntity;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.entity.carrier.BrewingStand;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.block.entity.BrewingEvent;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.common.item.util.ItemStackUtil;

@Mixin(value={BrewingStandBlockEntity.class})
public class BrewingStandBlockEntityMixin {
    @Shadow
    private int brewTime;
    @Shadow
    private int fuel;
    @Shadow
    private NonNullList<ItemStack> items;
    @Shadow
    private Item ingredient;

    @Inject(method={"tick"}, locals=LocalCapture.CAPTURE_FAILEXCEPTION, slice={@Slice(to=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/entity/BrewingStandBlockEntity;isBrewable()Z"))}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/entity/BrewingStandBlockEntity;setChanged()V")})
    private void impl$onConsumeFuel(CallbackInfo ci, ItemStack fuelStack) {
        Cause currentCause = Sponge.server().causeStackManager().currentCause();
        fuelStack.grow(1);
        ItemStackSnapshot originalStack = ItemStackUtil.snapshotOf(fuelStack);
        fuelStack.shrink(1);
        Transaction<ItemStackSnapshot> fuelTransaction = new Transaction<ItemStackSnapshot>(originalStack, ItemStackUtil.snapshotOf(fuelStack));
        ItemStackSnapshot ingredientStack = ItemStackUtil.snapshotOf((ItemStack)this.items.get(3));
        BrewingEvent.ConsumeFuel event = SpongeEventFactory.createBrewingEventConsumeFuel(currentCause, (BrewingStand)((Object)this), fuelTransaction, ingredientStack);
        if (Sponge.eventManager().post(event)) {
            fuelStack.grow(1);
            this.fuel = 0;
        } else if (event.fuel().custom().isPresent()) {
            ItemStackSnapshot finalFuel = event.fuel().finalReplacement();
            this.items.set(4, (Object)ItemStackUtil.fromSnapshotToNative(finalFuel));
        }
    }

    @Inject(method={"tick"}, locals=LocalCapture.CAPTURE_FAILEXCEPTION, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/entity/BrewingStandBlockEntity;isBrewable()Z"))}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/entity/BrewingStandBlockEntity;setChanged()V")})
    private void impl$callBrewEvents(CallbackInfo ci, ItemStack fuelStack, boolean isBrewable, boolean isBrewing, ItemStack ingredientStack) {
        Cause currentCause = Sponge.server().causeStackManager().currentCause();
        if (isBrewing) {
            if (this.brewTime == 0 && isBrewable) {
                ArrayList<ItemStackSnapshot> stacks = new ArrayList<ItemStackSnapshot>();
                for (int i = 0; i < 3; ++i) {
                    stacks.add(ItemStackUtil.snapshotOf((ItemStack)this.items.get(i)));
                }
                BrewingEvent.Finish event = SpongeEventFactory.createBrewingEventFinish(currentCause, Collections.unmodifiableList(stacks), (BrewingStand)((Object)this), ItemStackUtil.snapshotOf(ingredientStack));
                Sponge.eventManager().post(event);
            } else if (!isBrewable || this.ingredient != ingredientStack.getItem()) {
                BrewingEvent.Interrupt event = SpongeEventFactory.createBrewingEventInterrupt(currentCause, (BrewingStand)((Object)this), ItemStackUtil.snapshotOf(ingredientStack));
                Sponge.eventManager().post(event);
            }
        } else if (isBrewable && this.fuel > 0) {
            BrewingEvent.Start event = SpongeEventFactory.createBrewingEventStart(currentCause, (BrewingStand)((Object)this), ItemStackUtil.snapshotOf(ingredientStack));
            if (Sponge.eventManager().post(event)) {
                this.brewTime = 0;
                this.ingredient = Items.AIR;
                ++this.fuel;
            }
        }
    }

    @Inject(method={"tick"}, cancellable=true, locals=LocalCapture.CAPTURE_FAILEXCEPTION, at={@At(value="FIELD", target="Lnet/minecraft/world/level/block/entity/BrewingStandBlockEntity;brewTime:I", ordinal=1)})
    private void impl$onTick(CallbackInfo ci, ItemStack fuelStack, boolean isBrewable, boolean isBrewing, ItemStack ingredientStack) {
        if (this.brewTime != 0 && isBrewable && this.ingredient == ingredientStack.getItem()) {
            Cause currentCause = Sponge.server().causeStackManager().currentCause();
            BrewingEvent.Tick event = SpongeEventFactory.createBrewingEventTick(currentCause, (BrewingStand)((Object)this), ItemStackUtil.snapshotOf(ingredientStack));
            if (Sponge.eventManager().post(event)) {
                ++this.brewTime;
            }
        }
    }
}

