/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.level.chunk;

import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.util.ClassInstanceMultiMap;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.TickList;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkBiomeContainer;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.UpgradeData;
import net.minecraft.world.level.material.Fluid;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.util.Direction;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.accessor.server.level.ChunkMapAccessor;
import org.spongepowered.common.applaunch.config.core.SpongeConfigs;
import org.spongepowered.common.bridge.CreatorTrackedBridge;
import org.spongepowered.common.bridge.world.level.LevelBridge;
import org.spongepowered.common.bridge.world.level.chunk.CacheKeyBridge;
import org.spongepowered.common.bridge.world.level.chunk.LevelChunkBridge;
import org.spongepowered.common.bridge.world.level.storage.PrimaryLevelDataBridge;
import org.spongepowered.common.entity.PlayerTracker;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.util.DirectionUtil;

@Mixin(value={LevelChunk.class})
public abstract class LevelChunkMixin
implements LevelChunkBridge,
CacheKeyBridge {
    @Shadow
    @Final
    private Level level;
    @Shadow
    @Final
    private ChunkPos chunkPos;
    @Shadow
    @Final
    private ClassInstanceMultiMap<net.minecraft.world.entity.Entity>[] entitySections;
    @Shadow
    @Final
    private Map<BlockPos, BlockEntity> blockEntities;
    @Shadow
    private boolean loaded;
    @Shadow
    private boolean unsaved;
    private long impl$scheduledForUnload = -1L;
    private boolean impl$persistedChunk = false;
    private boolean impl$isSpawning = false;
    private final LevelChunk[] impl$neighbors = new LevelChunk[4];
    private long impl$cacheKey;
    private Map<Integer, PlayerTracker> impl$trackedIntBlockPositions = new HashMap<Integer, PlayerTracker>();
    private Map<Short, PlayerTracker> impl$trackedShortBlockPositions = new HashMap<Short, PlayerTracker>();

    @Shadow
    @Nullable
    public abstract BlockEntity shadow$getBlockEntity(BlockPos var1, LevelChunk.EntityCreationType var2);

    @Shadow
    public abstract BlockState shadow$getBlockState(BlockPos var1);

    @Shadow
    public abstract void shadow$addEntity(net.minecraft.world.entity.Entity var1);

    @Inject(method={"<init>(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/level/ChunkPos;Lnet/minecraft/world/level/chunk/ChunkBiomeContainer;Lnet/minecraft/world/level/chunk/UpgradeData;Lnet/minecraft/world/level/TickList;Lnet/minecraft/world/level/TickList;J[Lnet/minecraft/world/level/chunk/LevelChunkSection;Ljava/util/function/Consumer;)V"}, at={@At(value="RETURN")})
    private void impl$onConstruct(Level p_i225781_1_, ChunkPos p_i225781_2_, ChunkBiomeContainer p_i225781_3_, UpgradeData p_i225781_4_, TickList<Block> p_i225781_5_, TickList<Fluid> p_i225781_6_, long p_i225781_7_, LevelChunkSection[] p_i225781_9_, Consumer<LevelChunk> p_i225781_10_, CallbackInfo ci) {
        this.impl$cacheKey = ChunkPos.asLong((int)p_i225781_2_.x, (int)p_i225781_2_.z);
    }

    @Override
    public LevelChunk[] bridge$getNeighborArray() {
        return Arrays.copyOf(this.impl$neighbors, this.impl$neighbors.length);
    }

    @Override
    public void bridge$markChunkDirty() {
        this.unsaved = true;
    }

    @Override
    public boolean bridge$isQueuedForUnload() {
        return ((ChunkMapAccessor)((ServerChunkCache)this.level.getChunkSource()).chunkMap).accessor$pendingUnloads().containsKey(this.chunkPos.toLong());
    }

    @Override
    public boolean bridge$isPersistedChunk() {
        return this.impl$persistedChunk;
    }

    @Override
    public boolean bridge$isSpawning() {
        return this.impl$isSpawning;
    }

    @Override
    public void bridge$setIsSpawning(boolean spawning) {
        this.impl$isSpawning = spawning;
    }

    @Override
    public Map<Integer, PlayerTracker> bridge$getTrackedIntPlayerPositions() {
        return this.impl$trackedIntBlockPositions;
    }

    @Override
    public Map<Short, PlayerTracker> bridge$getTrackedShortPlayerPositions() {
        return this.impl$trackedShortBlockPositions;
    }

    @Override
    public void bridge$setTrackedIntPlayerPositions(Map<Integer, PlayerTracker> trackedPositions) {
        this.impl$trackedIntBlockPositions = trackedPositions;
    }

    @Override
    public void bridge$setTrackedShortPlayerPositions(Map<Short, PlayerTracker> trackedPositions) {
        this.impl$trackedShortBlockPositions = trackedPositions;
    }

    @Override
    public void bridge$addTrackedBlockPosition(Block block, BlockPos pos, UUID uuid, PlayerTracker.Type trackerType) {
        if (((LevelBridge)this.level).bridge$isFake()) {
            return;
        }
        if (!PhaseTracker.getInstance().getPhaseContext().tracksCreatorsAndNotifiers()) {
            return;
        }
        BlockEntity blockEntity = this.blockEntities.get(pos);
        if (blockEntity != null && blockEntity instanceof CreatorTrackedBridge) {
            CreatorTrackedBridge trackedBlockEntity = (CreatorTrackedBridge)blockEntity;
            if (trackerType == PlayerTracker.Type.NOTIFIER) {
                if (Objects.equals(trackedBlockEntity.tracker$getNotifierUUID().orElse(null), uuid)) {
                    return;
                }
                trackedBlockEntity.tracker$setTrackedUUID(PlayerTracker.Type.NOTIFIER, uuid);
            } else {
                if (Objects.equals(trackedBlockEntity.tracker$getCreatorUUID().orElse(null), uuid)) {
                    return;
                }
                trackedBlockEntity.tracker$setTrackedUUID(PlayerTracker.Type.CREATOR, uuid);
            }
        }
        if (trackerType == PlayerTracker.Type.CREATOR) {
            this.impl$setTrackedUUID(pos, uuid, trackerType, (pt, idx) -> {
                pt.creatorindex = idx;
                pt.notifierIndex = idx;
            });
        } else {
            this.impl$setTrackedUUID(pos, uuid, trackerType, (pt, idx) -> {
                pt.notifierIndex = idx;
            });
        }
    }

    public Optional<UUID> bridge$trackedUUID(BlockPos pos, Function<PlayerTracker, Integer> func) {
        if (((LevelBridge)this.level).bridge$isFake()) {
            return Optional.empty();
        }
        int key = Constants.Sponge.blockPosToInt(pos);
        PlayerTracker intTracker = this.impl$trackedIntBlockPositions.get(key);
        if (intTracker != null) {
            int ownerIndex = func.apply(intTracker);
            return this.impl$getValidatedUUID(key, ownerIndex);
        }
        short shortKey = Constants.Sponge.blockPosToShort(pos);
        PlayerTracker shortTracker = this.impl$trackedShortBlockPositions.get(shortKey);
        if (shortTracker != null) {
            int ownerIndex = func.apply(shortTracker);
            return this.impl$getValidatedUUID(shortKey, ownerIndex);
        }
        return Optional.empty();
    }

    @Override
    public Optional<UUID> bridge$getBlockCreatorUUID(BlockPos pos) {
        return this.bridge$trackedUUID(pos, pt -> pt.creatorindex);
    }

    @Override
    public Optional<UUID> bridge$getBlockNotifierUUID(BlockPos pos) {
        return this.bridge$trackedUUID(pos, pt -> pt.notifierIndex);
    }

    private <T> void impl$computePlayerTracker(Map<T, PlayerTracker> map, T blockPos, int index, PlayerTracker.Type type, BiConsumer<PlayerTracker, Integer> consumer) {
        PlayerTracker tracker = map.get(blockPos);
        if (tracker != null) {
            consumer.accept(tracker, index);
        } else {
            map.put(blockPos, new PlayerTracker(index, type));
        }
    }

    private void impl$setTrackedUUID(BlockPos pos, UUID uuid, PlayerTracker.Type type, BiConsumer<PlayerTracker, Integer> consumer) {
        int index;
        if (((LevelBridge)this.level).bridge$isFake()) {
            return;
        }
        PrimaryLevelDataBridge worldInfo = (PrimaryLevelDataBridge)this.level.getLevelData();
        int n = index = uuid == null ? -1 : worldInfo.bridge$getIndexForUniqueId(uuid);
        if (pos.getY() <= 255) {
            short blockPos = Constants.Sponge.blockPosToShort(pos);
            this.impl$computePlayerTracker(this.impl$trackedShortBlockPositions, blockPos, index, type, consumer);
            return;
        }
        int blockPos = Constants.Sponge.blockPosToInt(pos);
        this.impl$computePlayerTracker(this.impl$trackedIntBlockPositions, blockPos, index, type, consumer);
    }

    @Override
    public void bridge$setBlockNotifier(BlockPos pos, @Nullable UUID uuid) {
        this.impl$setTrackedUUID(pos, uuid, PlayerTracker.Type.NOTIFIER, (pt, idx) -> {
            pt.notifierIndex = idx;
        });
    }

    @Override
    public void bridge$setBlockCreator(BlockPos pos, @Nullable UUID uuid) {
        this.impl$setTrackedUUID(pos, uuid, PlayerTracker.Type.CREATOR, (pt, idx) -> {
            pt.creatorindex = idx;
        });
    }

    private Optional<UUID> impl$getValidatedUUID(int key, int ownerIndex) {
        PrimaryLevelDataBridge worldInfo = (PrimaryLevelDataBridge)this.level.getLevelData();
        UUID uuid = worldInfo.bridge$getUniqueIdForIndex(ownerIndex).orElse(null);
        if (uuid != null) {
            if (SpongeConfigs.getCommon().get().world.invalidLookupUuids.contains(uuid)) {
                if (key <= Short.MAX_VALUE) {
                    this.impl$trackedShortBlockPositions.remove((short)key);
                }
                this.impl$trackedIntBlockPositions.remove(key);
                return Optional.empty();
            }
            return Optional.of(uuid);
        }
        return Optional.empty();
    }

    @Override
    public void bridge$setNeighborChunk(int index, @Nullable LevelChunk chunk) {
        this.impl$neighbors[index] = chunk;
    }

    @Override
    @Nullable
    public LevelChunk bridge$getNeighborChunk(int index) {
        return this.impl$neighbors[index];
    }

    @Override
    public List<LevelChunk> bridge$getNeighbors() {
        ArrayList<LevelChunk> neighborList = new ArrayList<LevelChunk>();
        for (LevelChunk neighbor : this.impl$neighbors) {
            if (neighbor == null) continue;
            neighborList.add(neighbor);
        }
        return neighborList;
    }

    @Override
    public boolean bridge$areNeighborsLoaded() {
        for (int i = 0; i < 4; ++i) {
            if (this.impl$neighbors[i] != null) continue;
            return false;
        }
        return true;
    }

    @Override
    public void bridge$setNeighbor(Direction direction, @Nullable LevelChunk neighbor) {
        this.impl$neighbors[DirectionUtil.directionToIndex((Direction)direction)] = neighbor;
    }

    @Override
    public long bridge$getScheduledForUnload() {
        return this.impl$scheduledForUnload;
    }

    @Override
    public void bridge$setScheduledForUnload(long scheduled) {
        this.impl$scheduledForUnload = scheduled;
    }

    @Override
    public boolean bridge$isActive() {
        if (this.bridge$isPersistedChunk()) {
            return true;
        }
        return this.loaded && !this.bridge$isQueuedForUnload() && this.bridge$getScheduledForUnload() == -1L;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("World", (Object)this.level).add("Position", (Object)(this.chunkPos.x + ":" + this.chunkPos.z)).add("super", (Object)super.toString()).toString();
    }

    @Override
    public long bridge$getCacheKey() {
        return this.impl$cacheKey;
    }

    @Override
    public boolean bridge$spawnEntity(Entity entity) {
        net.minecraft.world.entity.Entity mcEntity = (net.minecraft.world.entity.Entity)entity;
        BlockPos blockPos = mcEntity.blockPosition();
        if (this.chunkPos.x == blockPos.getX() >> 4 && this.chunkPos.z == blockPos.getZ() >> 4) {
            this.level.addFreshEntity(mcEntity);
            return true;
        }
        return false;
    }
}

