/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.inventory.event.world.inventory;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.item.ItemStack;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.item.inventory.Container;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.api.item.inventory.transaction.SlotTransaction;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.world.inventory.InventoryMenuBridge;
import org.spongepowered.common.bridge.world.inventory.container.MenuBridge;
import org.spongepowered.common.bridge.world.inventory.container.TrackedContainerBridge;
import org.spongepowered.common.bridge.world.level.LevelBridge;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.context.transaction.EffectTransactor;
import org.spongepowered.common.event.tracking.context.transaction.TransactionalCaptureSupplier;
import org.spongepowered.common.event.tracking.phase.tick.TileEntityTickContext;
import org.spongepowered.common.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.inventory.custom.SpongeInventoryMenu;
import org.spongepowered.common.item.util.ItemStackUtil;

@Mixin(value={AbstractContainerMenu.class})
public abstract class AbstractContainerMenuMixin_Inventory
implements TrackedContainerBridge,
InventoryAdapter {
    @Final
    @Shadow
    private NonNullList<ItemStack> lastSlots;
    @Final
    @Shadow
    public List<net.minecraft.world.inventory.Slot> slots;
    @Final
    @Shadow
    private List<ContainerListener> containerListeners;
    @Final
    @Shadow
    private List<DataSlot> dataSlots;
    private boolean impl$isClicking;
    private boolean impl$captureSuccess = false;

    @Shadow
    protected abstract ItemStack shadow$doClick(int var1, int var2, ClickType var3, Player var4);

    @Override
    public boolean bridge$capturePossible() {
        return this.impl$captureSuccess;
    }

    @Redirect(method={"doClick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/inventory/Slot;mayPickup(Lnet/minecraft/world/entity/player/Player;)Z", ordinal=0), slice=@Slice(from=@At(value="FIELD", target="Lnet/minecraft/world/inventory/ClickType;THROW:Lnet/minecraft/world/inventory/ClickType;"), to=@At(value="FIELD", target="Lnet/minecraft/world/inventory/ClickType;PICKUP_ALL:Lnet/minecraft/world/inventory/ClickType;")))
    private boolean impl$verifyReadOnlyMenu(net.minecraft.world.inventory.Slot slot, Player playerIn) {
        if (((LevelBridge)playerIn.level).bridge$isFake()) {
            slot.mayPickup(playerIn);
        }
        if (((MenuBridge)((Object)this)).bridge$isReadonlyMenu(slot)) {
            ((MenuBridge)((Object)this)).bridge$refreshListeners();
            return false;
        }
        return slot.mayPickup(playerIn);
    }

    @Redirect(method={"doClick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/inventory/AbstractContainerMenu;quickMoveStack(Lnet/minecraft/world/entity/player/Player;I)Lnet/minecraft/world/item/ItemStack;"))
    private ItemStack impl$transferStackInSlot(AbstractContainerMenu thisContainer, Player player, int slotId) {
        ItemStack result = thisContainer.quickMoveStack(player, slotId);
        if (((LevelBridge)player.level).bridge$isFake() || !(thisContainer.getSlot(slotId) instanceof ResultSlot)) {
            return result;
        }
        this.bridge$detectAndSendChanges(true);
        PhaseContext<@NonNull ?> context = PhaseTracker.SERVER.getPhaseContext();
        TrackingUtil.processBlockCaptures(context);
        return result;
    }

    @Redirect(method={"clicked"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/inventory/AbstractContainerMenu;doClick(IILnet/minecraft/world/inventory/ClickType;Lnet/minecraft/world/entity/player/Player;)Lnet/minecraft/world/item/ItemStack;"))
    private ItemStack inventory$wrapDoClickWithTransaction(AbstractContainerMenu menu, int slotId, int dragType, ClickType clickType, Player player) {
        if (((LevelBridge)player.level).bridge$isFake()) {
            return this.shadow$doClick(slotId, dragType, clickType, player);
        }
        PhaseContext<@NonNull ?> context = PhaseTracker.SERVER.getPhaseContext();
        TransactionalCaptureSupplier transactor = context.getTransactor();
        try {
            EffectTransactor ignored = transactor.logClickContainer(menu, slotId, dragType, clickType, player);
            try {
                this.impl$isClicking = true;
                ItemStack itemStack = this.shadow$doClick(slotId, dragType, clickType, player);
                if (ignored != null) {
                    ignored.close();
                }
                return itemStack;
            }
            catch (Throwable throwable) {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        finally {
            this.impl$isClicking = false;
        }
    }

    @Inject(method={"broadcastChanges"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$broadcastChangesWithTransactions(CallbackInfo ci) {
        if (!PhaseTracker.SERVER.onSidedThread()) {
            return;
        }
        this.bridge$detectAndSendChanges(false);
        this.impl$captureSuccess = true;
        ci.cancel();
    }

    @Override
    public void bridge$detectAndSendChanges(boolean captureOnly) {
        SpongeInventoryMenu menu = ((MenuBridge)((Object)this)).bridge$getMenu();
        ArrayList<Integer> changes = new ArrayList<Integer>();
        for (int i = 0; i < this.slots.size(); ++i) {
            net.minecraft.world.inventory.Slot slot = this.slots.get(i);
            ItemStack newStack = slot.getItem();
            ItemStack oldStack = (ItemStack)this.lastSlots.get(i);
            if (ItemStack.matches((ItemStack)oldStack, (ItemStack)newStack)) continue;
            changes.add(i);
        }
        for (Integer i : changes) {
            net.minecraft.world.inventory.Slot slot = this.slots.get(i);
            ItemStack newStack = slot.getItem();
            ItemStack oldStack = (ItemStack)this.lastSlots.get(i.intValue());
            if (this.impl$isClicking && menu != null && !menu.onChange(newStack, oldStack, (Container)((Object)this), i, slot)) {
                this.lastSlots.set(i.intValue(), (Object)oldStack.copy());
                this.impl$sendSlotContents(i, oldStack);
                continue;
            }
            this.impl$capture(i, newStack, oldStack);
            if (captureOnly) continue;
            oldStack = newStack.isEmpty() ? ItemStack.EMPTY : newStack.copy();
            this.lastSlots.set(i.intValue(), (Object)oldStack);
            for (ContainerListener listener : this.containerListeners) {
                listener.slotChanged((AbstractContainerMenu)this, i.intValue(), oldStack);
            }
        }
        this.impl$detectAndSendPropertyChanges();
        if (this instanceof InventoryMenuBridge) {
            ((InventoryMenuBridge)((Object)this)).bridge$markClean();
        }
    }

    private void impl$sendSlotContents(Integer i, ItemStack oldStack) {
        for (ContainerListener listener : this.containerListeners) {
            boolean isChangingQuantityOnly = true;
            if (listener instanceof ServerPlayer) {
                isChangingQuantityOnly = ((ServerPlayer)listener).ignoreSlotUpdateHack;
                ((ServerPlayer)listener).ignoreSlotUpdateHack = false;
            }
            listener.slotChanged((AbstractContainerMenu)this, i.intValue(), oldStack);
            if (!(listener instanceof ServerPlayer)) continue;
            ((ServerPlayer)listener).ignoreSlotUpdateHack = isChangingQuantityOnly;
        }
    }

    private void impl$detectAndSendPropertyChanges() {
        for (int j = 0; j < this.dataSlots.size(); ++j) {
            DataSlot intreferenceholder = this.dataSlots.get(j);
            if (!intreferenceholder.checkAndClearUpdateFlag()) continue;
            for (ContainerListener icontainerlistener1 : this.containerListeners) {
                icontainerlistener1.setContainerData((AbstractContainerMenu)this, j, intreferenceholder.get());
            }
        }
    }

    private void impl$capture(Integer index, ItemStack newStack, ItemStack oldStack) {
        PhaseContext<?> phaseContext = PhaseTracker.SERVER.getPhaseContext();
        if (PhaseTracker.SERVER.onSidedThread() && !phaseContext.isRestoring() && !(phaseContext instanceof TileEntityTickContext)) {
            ItemStackSnapshot oldItem = ItemStackUtil.snapshotOf(oldStack);
            ItemStackSnapshot newItem = ItemStackUtil.snapshotOf(newStack);
            try {
                Slot adapter = this.inventoryAdapter$getSlot(index).get();
                SlotTransaction newTransaction = new SlotTransaction(adapter, oldItem, newItem);
                phaseContext.getTransactor().logSlotTransaction(phaseContext, newTransaction, (AbstractContainerMenu)this);
            }
            catch (IndexOutOfBoundsException e) {
                SpongeCommon.logger().error("SlotIndex out of LensBounds! Did the Container change after creation?", (Throwable)e);
            }
        }
    }
}

