/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.optimization.world.level.block.entity;

import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.mixin.core.world.level.block.entity.RandomizableContainerBlockEntityMixin;

@Mixin(value={ChestBlockEntity.class})
public abstract class ChestBlockEntityMixin_Optimization_BlockEntity
extends RandomizableContainerBlockEntityMixin {
    @Shadow
    protected float openness;
    @Shadow
    protected int openCount;
    @Shadow
    private int tickInterval;
    @Shadow
    protected float oOpenness;

    @Shadow
    protected abstract void shadow$playSound(SoundEvent var1);

    @Shadow
    public static int shadow$getOpenCount(Level p_213977_0_, BaseContainerBlockEntity p_213977_1_, int p_213977_2_, int p_213977_3_, int p_213977_4_, int p_213977_5_, int p_213977_6_) {
        throw new UnsupportedOperationException("Shadowed getOpenCount");
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$DisableTickingChestsOnServer(CallbackInfo ci) {
        ++this.tickInterval;
        ci.cancel();
    }

    @Inject(method={"playSound"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$onPlaySound(SoundEvent soundIn, CallbackInfo ci) {
        if (!this.shadow$getBlockState().hasProperty((Property)ChestBlock.TYPE)) {
            ci.cancel();
        }
    }

    @Inject(method={"startOpen"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/entity/ChestBlockEntity;signalOpenCount()V")})
    private void impl$onOpenInventory(Player player, CallbackInfo ci) {
        this.impl$doOpenLogic();
    }

    @Inject(method={"stopOpen"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/entity/ChestBlockEntity;signalOpenCount()V")})
    private void impl$onCloseInventory(Player player, CallbackInfo ci) {
        this.impl$doCloseLogic();
    }

    private void impl$doOpenLogic() {
        int x = this.worldPosition.getX();
        int y = this.worldPosition.getY();
        int z = this.worldPosition.getZ();
        ++this.tickInterval;
        this.openCount = ChestBlockEntityMixin_Optimization_BlockEntity.shadow$getOpenCount(this.level, (BaseContainerBlockEntity)this, this.tickInterval, x, y, z, this.openCount);
        this.oOpenness = this.openness;
        if (this.openCount > 0 && this.openness == 0.0f) {
            this.shadow$playSound(SoundEvents.CHEST_OPEN);
        }
    }

    private void impl$doCloseLogic() {
        if (this.openCount == 0) {
            float lvt_5_1_ = this.openness;
            this.openness = this.openCount > 0 ? (this.openness += 0.1f) : (this.openness -= 0.1f);
            if (this.openness > 1.0f) {
                this.openness = 1.0f;
            }
            if (this.openness < 0.5f && lvt_5_1_ >= 0.5f) {
                this.shadow$playSound(SoundEvents.CHEST_CLOSE);
            }
            if (this.openness < 0.0f) {
                this.openness = 0.0f;
            }
        }
    }
}

