/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.realtime.server.network;

import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.common.bridge.RealTimeTrackingBridge;
import org.spongepowered.common.bridge.world.entity.PlatformEntityBridge;
import org.spongepowered.common.bridge.world.level.LevelBridge;

@Mixin(value={ServerGamePacketListenerImpl.class})
public abstract class ServerGamePacketListenerImplMixin_RealTime {
    @Shadow
    private int chatSpamTickCount;
    @Shadow
    private int dropSpamTickCount;
    @Shadow
    @Final
    private MinecraftServer server;
    @Shadow
    public ServerPlayer player;

    @Redirect(method={"tick"}, at=@At(value="FIELD", target="Lnet/minecraft/server/network/ServerGamePacketListenerImpl;chatSpamTickCount:I", opcode=181, ordinal=0))
    private void realTimeImpl$adjustForRealTimeChatSpamCheck(ServerGamePacketListenerImpl self, int modifier) {
        if (((PlatformEntityBridge)this.player).bridge$isFakePlayer() || ((LevelBridge)this.player.level).bridge$isFake()) {
            this.chatSpamTickCount = modifier;
            return;
        }
        int ticks = (int)((RealTimeTrackingBridge)this.server).realTimeBridge$getRealTimeTicks();
        this.chatSpamTickCount = Math.max(0, this.chatSpamTickCount - ticks);
    }

    @Redirect(method={"tick"}, at=@At(value="FIELD", target="Lnet/minecraft/server/network/ServerGamePacketListenerImpl;dropSpamTickCount:I", opcode=181, ordinal=0))
    private void realTimeImpl$adjustForRealTimeDropSpamCheck(ServerGamePacketListenerImpl self, int modifier) {
        if (((PlatformEntityBridge)this.player).bridge$isFakePlayer() || ((LevelBridge)this.player.level).bridge$isFake()) {
            this.dropSpamTickCount = modifier;
            return;
        }
        int ticks = (int)((RealTimeTrackingBridge)this.server).realTimeBridge$getRealTimeTicks();
        this.dropSpamTickCount = Math.max(0, this.dropSpamTickCount - ticks);
    }
}

