/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.tracker.server.players;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.context.GeneralizedContext;
import org.spongepowered.common.event.tracking.phase.block.BlockPhase;
import org.spongepowered.common.event.tracking.phase.player.PlayerPhase;

@Mixin(value={PlayerList.class})
public class PlayerListMixin_Tracker {
    @Redirect(method={"remove"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;removePlayerImmediately(Lnet/minecraft/server/level/ServerPlayer;)V"))
    private void tracker$trackPlayerLogoutThroughPhaseTracker(ServerLevel world, ServerPlayer player) {
        try (GeneralizedContext context = (GeneralizedContext)PlayerPhase.State.PLAYER_LOGOUT.createPhaseContext(PhaseTracker.SERVER).source(player);){
            context.buildAndSwitch();
            world.removePlayerImmediately(player);
        }
    }

    @Redirect(method={"placeNewPlayer"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;initMenu()V"))
    private void tracker$onInitMenu(ServerPlayer player) {
        try (Object context = ((PhaseContext)BlockPhase.State.RESTORING_BLOCKS.createPhaseContext(PhaseTracker.SERVER)).source(player);){
            ((PhaseContext)context).buildAndSwitch();
            player.initMenu();
        }
    }
}

