/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.tracker.world.level;

import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.bridge.world.TrackedWorldBridge;
import org.spongepowered.common.bridge.world.level.ExplosionBridge;
import org.spongepowered.common.event.tracking.BlockChangeFlagManager;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.context.transaction.effect.AddBlockLootDropsEffect;
import org.spongepowered.common.event.tracking.context.transaction.effect.ExplodeBlockEffect;
import org.spongepowered.common.event.tracking.context.transaction.effect.SpawnDestructBlocksEffect;
import org.spongepowered.common.event.tracking.context.transaction.effect.WorldBlockChangeCompleteEffect;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.WorldPipeline;

@Mixin(value={Explosion.class})
public abstract class ExplosionMixin_Tracker {
    @Shadow
    @Final
    private Level level;
    @Shadow
    @Final
    private double x;
    @Shadow
    @Final
    private double y;
    @Shadow
    @Final
    private double z;
    @Shadow
    @Final
    private Explosion.BlockInteraction blockInteraction;
    @Shadow
    @Final
    private float radius;
    @Shadow
    @Final
    private List<BlockPos> toBlow;
    @Shadow
    @Final
    private boolean fire;
    @Shadow
    @Final
    private Random random;

    @Overwrite
    public void finalizeExplosion(boolean spawnParticles) {
        boolean flag;
        if (this.level.isClientSide) {
            return;
        }
        this.level.playSound(null, this.x, this.y, this.z, SoundEvents.GENERIC_EXPLODE, SoundSource.BLOCKS, 4.0f, (1.0f + (this.level.random.nextFloat() - this.level.random.nextFloat()) * 0.2f) * 0.7f);
        boolean bl = flag = this.blockInteraction != Explosion.BlockInteraction.NONE;
        if (spawnParticles) {
            if (!(this.radius < 2.0f) && (flag || ((ExplosionBridge)((Object)this)).bridge$getShouldDamageBlocks())) {
                if (this.level instanceof ServerLevel) {
                    ((ServerLevel)this.level).sendParticles((ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, this.x, this.y, this.z, 1, 0.0, 0.0, 0.0, 0.1);
                } else {
                    this.level.addParticle((ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, this.x, this.y, this.z, 1.0, 0.0, 0.0);
                }
            } else if (this.level instanceof ServerLevel) {
                ((ServerLevel)this.level).sendParticles((ParticleOptions)ParticleTypes.EXPLOSION, this.x, this.y, this.z, 1, 0.0, 0.0, 0.0, 0.1);
            } else {
                this.level.addParticle((ParticleOptions)ParticleTypes.EXPLOSION, this.x, this.y, this.z, 1.0, 0.0, 0.0);
            }
        }
        if (flag) {
            Collections.shuffle(this.toBlow, this.level.random);
            for (BlockPos blockpos : this.toBlow) {
                BlockState blockstate = this.level.getBlockState(blockpos);
                if (blockstate.isAir()) continue;
                BlockPos blockpos1 = blockpos.immutable();
                this.level.getProfiler().push("explosion_blocks");
                PhaseContext<@NonNull ?> context = PhaseTracker.getInstance().getPhaseContext();
                ((TrackedWorldBridge)this.level).bridge$startBlockChange(blockpos1, Blocks.AIR.defaultBlockState(), 3).ifPresent(builder -> {
                    WorldPipeline build = builder.addEffect(AddBlockLootDropsEffect.getInstance()).addEffect(ExplodeBlockEffect.getInstance()).addEffect(SpawnDestructBlocksEffect.getInstance()).addEffect(WorldBlockChangeCompleteEffect.getInstance()).build();
                    build.processEffects(context, blockstate, Blocks.AIR.defaultBlockState(), blockpos1, null, BlockChangeFlagManager.fromNativeInt(3), 512);
                });
                this.level.getProfiler().pop();
            }
        }
        if (this.fire) {
            for (BlockPos blockpos2 : this.toBlow) {
                if (this.random.nextInt(3) != 0 || !this.level.getBlockState(blockpos2).isAir() || !this.level.getBlockState(blockpos2.below()).isSolidRender((BlockGetter)this.level, blockpos2.below())) continue;
                this.level.setBlockAndUpdate(blockpos2, BaseFireBlock.getState((BlockGetter)this.level, (BlockPos)blockpos2));
            }
        }
    }
}

