/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.profile;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Server;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.profile.GameProfileCache;
import org.spongepowered.api.profile.GameProfileManager;
import org.spongepowered.api.profile.GameProfileProvider;
import org.spongepowered.common.SpongeServer;
import org.spongepowered.common.applaunch.config.core.SpongeConfigs;
import org.spongepowered.common.bridge.server.players.GameProfileCacheBridge;
import org.spongepowered.common.bridge.server.players.GameProfileCache_GameProfileInfoBridge;
import org.spongepowered.common.profile.SpongeGameProfile;
import org.spongepowered.common.profile.UncachedGameProfileProvider;
import org.spongepowered.common.util.PrettyPrinter;
import org.spongepowered.common.util.UsernameCache;

public final class SpongeGameProfileManager
implements GameProfileManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private final UsernameCache usernameCache;
    private final GameProfileCacheBridge cache;
    private final UncachedGameProfileProvider uncached = new UncachedGameProfileProvider();
    private final ExecutorService gameLookupExecutorService;

    public SpongeGameProfileManager(Server server) {
        this.usernameCache = ((SpongeServer)server).getUsernameCache();
        this.cache = (GameProfileCacheBridge)((MinecraftServer)server).getProfileCache();
        this.gameLookupExecutorService = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("Sponge - Async User Lookup Thread").build());
    }

    static boolean canLookup(UUID id) {
        return id.version() == 4;
    }

    @Override
    public GameProfileCache cache() {
        return this.cache;
    }

    @Override
    public GameProfileProvider uncached() {
        return this.uncached;
    }

    @Override
    public CompletableFuture<GameProfile> basicProfile(UUID uniqueId) {
        Objects.requireNonNull(uniqueId, "uniqueId");
        Optional<GameProfileCache_GameProfileInfoBridge> entry = this.cache.bridge$getEntry(uniqueId);
        if (entry.isPresent()) {
            return CompletableFuture.completedFuture(entry.get().bridge$getBasic());
        }
        String cachedName = this.usernameCache.getLastKnownUsername(uniqueId);
        if (cachedName != null) {
            SpongeGameProfile profile2 = new SpongeGameProfile(uniqueId, cachedName);
            this.cache.bridge$addBasic(profile2);
            return CompletableFuture.completedFuture(profile2);
        }
        return this.uncached().basicProfile(uniqueId).thenApply(profile -> {
            this.cache.bridge$addBasic((GameProfile)profile);
            return profile;
        });
    }

    @Override
    public CompletableFuture<GameProfile> basicProfile(String name, @Nullable Instant time) {
        Objects.requireNonNull(name, "name");
        if (time != null) {
            return this.uncached().basicProfile(name, time);
        }
        return this.cache.bridge$getEntry(name).flatMap(entry -> Optional.ofNullable(entry.bridge$getBasic())).map(CompletableFuture::completedFuture).orElseGet(() -> this.uncached().basicProfile(name).thenApply(profile -> {
            this.cache.bridge$addBasic((GameProfile)profile);
            return profile;
        }));
    }

    @Override
    public CompletableFuture<Map<String, GameProfile>> basicProfiles(Iterable<String> names, @Nullable Instant time) {
        Objects.requireNonNull(names, "names");
        if (time != null) {
            return this.uncached().basicProfiles(names, time);
        }
        HashMap<String, GameProfile> result = new HashMap<String, GameProfile>();
        ArrayList<String> toLookup = new ArrayList<String>();
        for (String name : names) {
            Optional profile = this.cache.bridge$getEntry(name).flatMap(entry -> Optional.ofNullable(entry.bridge$getBasic()));
            if (profile.isPresent()) {
                result.put(name, (GameProfile)profile.get());
                continue;
            }
            toLookup.add(name);
        }
        if (toLookup.isEmpty()) {
            return CompletableFuture.completedFuture(result);
        }
        return this.uncached().basicProfiles(toLookup).thenApply(lookedUp -> {
            for (GameProfile profile : lookedUp.values()) {
                this.cache.bridge$addBasic(profile);
            }
            result.putAll((Map<String, GameProfile>)lookedUp);
            return result;
        });
    }

    @Override
    public CompletableFuture<GameProfile> profile(String name, boolean signed) {
        Objects.requireNonNull(name, "name");
        return this.cache.bridge$getEntry(name).flatMap(entry -> Optional.ofNullable(entry.bridge$getFull(signed))).map(CompletableFuture::completedFuture).orElseGet(() -> this.uncached().profile(name, signed).thenApply(profile -> {
            this.cache.bridge$add((GameProfile)profile, true, signed);
            return profile;
        }));
    }

    @Override
    public CompletableFuture<GameProfile> profile(UUID uniqueId, boolean signed) {
        Objects.requireNonNull(uniqueId, "uniqueId");
        return this.cache.bridge$getEntry(uniqueId).flatMap(entry -> Optional.ofNullable(entry.bridge$getFull(signed))).map(CompletableFuture::completedFuture).orElseGet(() -> this.uncached().profile(uniqueId, signed).thenApply(profile -> {
            this.cache.bridge$add((GameProfile)profile, true, signed);
            return profile;
        }));
    }

    public void lookupUserAsync(UUID uniqueId) {
        Objects.requireNonNull(uniqueId, "uniqueId");
        this.gameLookupExecutorService.execute(() -> {
            try {
                this.basicProfile(uniqueId).get();
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
            if (SpongeGameProfileManager.canLookup(uniqueId)) {
                try {
                    Thread.sleep((long)SpongeConfigs.getCommon().get().world.gameProfileQueryTaskInterval * 1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void close() {
        this.gameLookupExecutorService.shutdown();
        try {
            if (!this.gameLookupExecutorService.awaitTermination(5L, TimeUnit.SECONDS)) {
                List<Runnable> remaining = this.gameLookupExecutorService.shutdownNow();
                new PrettyPrinter().add("Sponge game profile resolver failed to shut down in 5 seconds!").add("Remaining tasks:").addWithIndices(remaining).add("These tasks have been cancelled.").log(LOGGER, Level.WARN);
            }
        }
        catch (InterruptedException e) {
            LOGGER.error("The async scheduler was interrupted while awaiting shutdown!");
        }
    }
}

