/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.profile;

import com.mojang.authlib.properties.Property;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.Queries;
import org.spongepowered.api.profile.property.ProfileProperty;

public final class SpongeProfileProperty
implements ProfileProperty {
    private final String name;
    private final String value;
    private final @Nullable String signature;

    public SpongeProfileProperty(Property property) {
        this(property.getName(), property.getValue(), property.getSignature());
    }

    public SpongeProfileProperty(String name, String value, @Nullable String signature) {
        this.name = name;
        this.value = value;
        this.signature = signature;
    }

    @Override
    public int contentVersion() {
        return 1;
    }

    @Override
    public @NonNull DataContainer toContainer() {
        DataContainer container = DataContainer.createNew().set(Queries.CONTENT_VERSION, this.contentVersion()).set(Queries.PROPERTY_NAME, this.name).set(Queries.PROPERTY_VALUE, this.value);
        if (this.signature != null) {
            container.set(Queries.PROPERTY_SIGNATURE, this.signature);
        }
        return container;
    }

    @Override
    public @NonNull String name() {
        return this.name;
    }

    @Override
    public @NonNull String value() {
        return this.value;
    }

    @Override
    public @NonNull Optional<String> signature() {
        return Optional.ofNullable(this.signature);
    }

    public Property asProperty() {
        return new Property(this.name, this.value, this.signature);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.value, this.signature);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SpongeProfileProperty)) {
            return false;
        }
        SpongeProfileProperty other = (SpongeProfileProperty)obj;
        return other.name().equals(this.name) && other.value().equals(this.value) && Objects.equals(other.signature, this.signature);
    }

    public String toString() {
        return new StringJoiner(", ", Property.class.getSimpleName() + "[", "]").add("name='" + this.name + "'").add("value='" + this.value + "'").add("signature='" + this.signature + "'").toString();
    }
}

