/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry;

import java.util.Map;
import java.util.OptionalInt;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;

public abstract class InitialRegistryData<T> {
    abstract Map<ResourceKey, T> keyToValue();

    abstract @Nullable Map<ResourceKey, Integer> keyToId();

    void forEach(LoaderConsumer<T> consumer) {
        Map<ResourceKey, T> kv = this.keyToValue();
        Map<ResourceKey, Integer> ki = this.keyToId();
        for (Map.Entry<ResourceKey, T> entry : kv.entrySet()) {
            Integer ni;
            OptionalInt id = ki != null ? ((ni = ki.get(entry.getKey())) != null ? OptionalInt.of(ni) : OptionalInt.empty()) : OptionalInt.empty();
            consumer.accept(entry.getKey(), id, entry.getValue());
        }
    }

    static <T> @Nullable InitialRegistryData<T> noIds(final @Nullable Supplier<Map<ResourceKey, T>> values) {
        if (values == null) {
            return null;
        }
        return new InitialRegistryData<T>(){

            @Override
            Map<ResourceKey, T> keyToValue() {
                return (Map)values.get();
            }

            @Override
            @Nullable Map<ResourceKey, Integer> keyToId() {
                return null;
            }
        };
    }

    static interface LoaderConsumer<T> {
        public void accept(ResourceKey var1, OptionalInt var2, T var3);
    }
}

