/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry;

import com.google.common.collect.HashBiMap;
import com.mojang.serialization.Lifecycle;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.StaticTagHelper;
import net.minecraft.tags.Tag;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.registry.RegistryEntry;
import org.spongepowered.api.registry.RegistryType;
import org.spongepowered.common.bridge.core.RegistryBridge;
import org.spongepowered.common.bridge.tags.TagWrapperBridge;
import org.spongepowered.common.registry.SpongeRegistryEntry;

public final class TagRegistry<T>
extends Registry<org.spongepowered.api.tag.Tag<T>> {
    private final StaticTagHelper<T> staticTagHelper;
    private final Map<org.spongepowered.api.ResourceKey, org.spongepowered.api.tag.Tag<T>> wrapperCache = HashBiMap.create();
    private final Lifecycle lifecycle;
    private final RegistryType<org.spongepowered.api.tag.Tag<T>> type;

    public TagRegistry(ResourceKey<? extends Registry<org.spongepowered.api.tag.Tag<T>>> registryKey, StaticTagHelper<T> staticTagHelper, Lifecycle lifecycle) {
        super(registryKey, lifecycle);
        this.staticTagHelper = staticTagHelper;
        this.lifecycle = lifecycle;
        RegistryBridge bridge = (RegistryBridge)((Object)this);
        this.type = bridge.bridge$type();
        bridge.bridge$overrideStream(this::tagStream);
    }

    public @Nullable ResourceLocation getKey(org.spongepowered.api.tag.Tag<T> var1) {
        return this.staticTagHelper.getAllTags().getId((Tag)var1);
    }

    public Optional<ResourceKey<org.spongepowered.api.tag.Tag<T>>> getResourceKey(org.spongepowered.api.tag.Tag<T> var1) {
        ResourceLocation valueLocation = this.getKey(var1);
        if (valueLocation == null) {
            return Optional.empty();
        }
        return Optional.of(ResourceKey.create((ResourceKey)this.key(), (ResourceLocation)valueLocation));
    }

    public int getId(@Nullable org.spongepowered.api.tag.Tag<T> var1) {
        throw new UnsupportedOperationException("IDs are not supported!");
    }

    public @Nullable org.spongepowered.api.tag.Tag<T> byId(int var1) {
        throw new UnsupportedOperationException("IDs are not supported!");
    }

    public @Nullable org.spongepowered.api.tag.Tag<T> get(ResourceKey<org.spongepowered.api.tag.Tag<T>> resourceKey) {
        if (!resourceKey.isFor(this.key())) {
            throw new IllegalStateException("Minecraft ResourceKey " + resourceKey + " is not for registry " + this.key());
        }
        return this.get(resourceKey.location());
    }

    public @Nullable org.spongepowered.api.tag.Tag<T> get(@Nullable ResourceLocation key) {
        org.spongepowered.api.tag.Tag<T> cachedTag = this.wrapperCache.get(key);
        if (cachedTag != null) {
            return cachedTag;
        }
        Tag setTag = this.staticTagHelper.getAllTags().getTag(key);
        if (setTag == null) {
            return null;
        }
        return this.getWrapped((org.spongepowered.api.ResourceKey)key, setTag);
    }

    protected Lifecycle lifecycle(org.spongepowered.api.tag.Tag<T> var1) {
        return this.lifecycle;
    }

    public Lifecycle elementsLifecycle() {
        return this.lifecycle;
    }

    public Set<ResourceLocation> keySet() {
        return Collections.unmodifiableSet(this.staticTagHelper.getAllTags().getAllTags().keySet());
    }

    public Set<Map.Entry<ResourceKey<org.spongepowered.api.tag.Tag<T>>, org.spongepowered.api.tag.Tag<T>>> entrySet() {
        return Collections.unmodifiableSet(this.staticTagHelper.getAllTags().getAllTags().entrySet().stream().map(entry -> new AbstractMap.SimpleEntry<ResourceKey, org.spongepowered.api.tag.Tag<T>>(ResourceKey.create((ResourceKey)this.key(), (ResourceLocation)((ResourceLocation)entry.getKey())), this.getWrapped((org.spongepowered.api.ResourceKey)entry.getKey(), (Tag)entry.getValue()))).collect(Collectors.toSet()));
    }

    public Stream<org.spongepowered.api.tag.Tag<T>> stream() {
        return this.tagStream().map(RegistryEntry::value);
    }

    public boolean containsKey(ResourceLocation var1) {
        return this.staticTagHelper.getAllTags().getAllTags().containsKey(var1);
    }

    public @NonNull Iterator<org.spongepowered.api.tag.Tag<T>> iterator() {
        return this.tagStream().map(RegistryEntry::value).iterator();
    }

    private org.spongepowered.api.tag.Tag<T> getWrapped(org.spongepowered.api.ResourceKey key, Tag<T> setTag) {
        org.spongepowered.api.tag.Tag<T> cached = this.wrapperCache.get(key);
        if (cached != null) {
            return cached;
        }
        org.spongepowered.api.tag.Tag result = this.staticTagHelper.getWrappers().stream().filter(named -> named.getName().equals((Object)key)).map(tag -> (org.spongepowered.api.tag.Tag)tag).findAny().orElseGet(() -> {
            org.spongepowered.api.tag.Tag tag = (org.spongepowered.api.tag.Tag)this.staticTagHelper.bind(key.asString());
            ((TagWrapperBridge)((Object)tag)).bridge$rebindTo(setTag);
            return tag;
        });
        this.wrapperCache.put(key, result);
        return result;
    }

    private Stream<RegistryEntry<org.spongepowered.api.tag.Tag<T>>> tagStream() {
        return this.staticTagHelper.getAllTags().getAllTags().entrySet().stream().map(x -> {
            org.spongepowered.api.ResourceKey resourceKey = (org.spongepowered.api.ResourceKey)x.getKey();
            return new SpongeRegistryEntry<org.spongepowered.api.tag.Tag<T>>(this.type, resourceKey, this.getWrapped(resourceKey, (Tag)x.getValue()));
        });
    }
}

