/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.provider;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import net.minecraft.world.level.biome.FuzzyOffsetBiomeZoomer;
import net.minecraft.world.level.biome.FuzzyOffsetConstantColumnBiomeZoomer;
import net.minecraft.world.level.biome.NearestNeighborBiomeZoomer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.world.biome.BiomeSampler;

public final class BiomeSamplerProvider {
    public static BiomeSamplerProvider INSTANCE = new BiomeSamplerProvider();
    private final BiMap<ResourceKey, BiomeSampler> mappings = HashBiMap.create();

    private BiomeSamplerProvider() {
        this.mappings.put((Object)ResourceKey.sponge("column_fuzzed"), (Object)((BiomeSampler)FuzzyOffsetConstantColumnBiomeZoomer.INSTANCE));
        this.mappings.put((Object)ResourceKey.sponge("fuzzy"), (Object)((BiomeSampler)FuzzyOffsetBiomeZoomer.INSTANCE));
        this.mappings.put((Object)ResourceKey.sponge("default"), (Object)((BiomeSampler)NearestNeighborBiomeZoomer.INSTANCE));
    }

    public @Nullable BiomeSampler get(ResourceKey key) {
        return (BiomeSampler)this.mappings.get((Object)key);
    }

    public @Nullable ResourceKey get(BiomeSampler biomeSampler) {
        return (ResourceKey)this.mappings.inverse().get((Object)biomeSampler);
    }
}

