/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.service.server.permission;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.spongepowered.api.service.permission.NodeTree;
import org.spongepowered.api.util.Tristate;

public final class SpongeNodeTree
implements NodeTree {
    private static final Pattern NODE_SPLIT = Pattern.compile("\\.");
    private final Node rootNode;

    SpongeNodeTree(Tristate value) {
        this.rootNode = new Node(new HashMap<String, Node>());
        this.rootNode.value = value;
    }

    SpongeNodeTree(Node rootNode) {
        this.rootNode = rootNode;
    }

    <T> void populate(Map<String, T> values, Function<T, Tristate> converter) {
        for (Map.Entry<String, T> value : values.entrySet()) {
            String[] parts = NODE_SPLIT.split(value.getKey().toLowerCase(), -1);
            Node currentNode = this.rootNode;
            for (String part : parts) {
                if (currentNode.children.containsKey(part)) {
                    currentNode = currentNode.children.get(part);
                    continue;
                }
                Node newNode = new Node(new HashMap<String, Node>());
                currentNode.children.put(part, newNode);
                currentNode = newNode;
            }
            currentNode.value = converter.apply(value.getValue());
        }
    }

    @Override
    public Tristate get(String node) {
        String[] parts = NODE_SPLIT.split(node.toLowerCase(), -1);
        Node currentNode = this.rootNode;
        Tristate lastUndefinedVal = Tristate.UNDEFINED;
        for (String str : parts) {
            if (!currentNode.children.containsKey(str)) break;
            currentNode = currentNode.children.get(str);
            if (currentNode.value == Tristate.UNDEFINED) continue;
            lastUndefinedVal = currentNode.value;
        }
        return lastUndefinedVal;
    }

    @Override
    public Tristate rootValue() {
        return this.rootNode.value;
    }

    @Override
    public NodeTree withRootValue(Tristate state) {
        Node newRoot = new Node(this.rootNode.children);
        newRoot.value = Objects.requireNonNull(state, "state");
        return new SpongeNodeTree(newRoot);
    }

    @Override
    public Map<String, Boolean> asMap() {
        ImmutableMap.Builder ret = ImmutableMap.builder();
        for (Map.Entry<String, Node> ent : this.rootNode.children.entrySet()) {
            this.populateMap((ImmutableMap.Builder<String, Boolean>)ret, ent.getKey(), ent.getValue());
        }
        return ret.build();
    }

    private void populateMap(ImmutableMap.Builder<String, Boolean> values, String prefix, Node currentNode) {
        if (currentNode.value != Tristate.UNDEFINED) {
            values.put((Object)prefix, (Object)currentNode.value.asBoolean());
        }
        for (Map.Entry<String, Node> ent : currentNode.children.entrySet()) {
            this.populateMap(values, prefix + '.' + ent.getKey(), ent.getValue());
        }
    }

    @Override
    public NodeTree withValue(String node, Tristate value) {
        Node newRoot;
        String[] parts = NODE_SPLIT.split(node.toLowerCase(), -1);
        Node newPtr = newRoot = new Node(new HashMap<String, Node>(this.rootNode.children));
        Node currentPtr = this.rootNode;
        newPtr.value = currentPtr == null ? Tristate.UNDEFINED : currentPtr.value;
        for (String part : parts) {
            Node oldChild = currentPtr == null ? null : currentPtr.children.get(part);
            Node newChild = new Node((Map<String, Node>)(oldChild != null ? new HashMap<String, Node>(oldChild.children) : new HashMap()));
            newPtr.children.put(part, newChild);
            currentPtr = oldChild;
            newPtr = newChild;
        }
        newPtr.value = value;
        return new SpongeNodeTree(newRoot);
    }

    @Override
    public NodeTree withAll(Map<String, Boolean> values) {
        NodeTree ret = this;
        for (Map.Entry<String, Boolean> ent : values.entrySet()) {
            ret = ret.withValue(ent.getKey(), Tristate.fromBoolean(ent.getValue()));
        }
        return ret;
    }

    @Override
    public NodeTree withAllTristates(Map<String, Tristate> values) {
        NodeTree ret = this;
        for (Map.Entry<String, Tristate> ent : values.entrySet()) {
            ret = ret.withValue(ent.getKey(), ent.getValue());
        }
        return ret;
    }

    public static final class FactoryImpl
    implements NodeTree.Factory {
        @Override
        public NodeTree ofBooleans(Map<String, Boolean> values, Tristate defaultValue) {
            SpongeNodeTree newTree = new SpongeNodeTree(defaultValue);
            newTree.populate(values, Tristate::fromBoolean);
            return newTree;
        }

        @Override
        public NodeTree ofTristates(Map<String, Tristate> values, Tristate defaultValue) {
            SpongeNodeTree newTree = new SpongeNodeTree(defaultValue);
            newTree.populate(values, Function.identity());
            return newTree;
        }
    }

    public static class Node {
        final Map<String, Node> children;
        Tristate value = Tristate.UNDEFINED;

        Node(Map<String, Node> children) {
            this.children = children;
        }
    }
}

