/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.service.server.permission;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.service.context.Contextual;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.service.permission.SubjectCollection;
import org.spongepowered.api.service.permission.SubjectReference;
import org.spongepowered.api.util.Tristate;
import org.spongepowered.common.service.server.permission.SpongePermissionService;
import org.spongepowered.common.service.server.permission.SpongeSubject;

public abstract class SpongeSubjectCollection
implements SubjectCollection {
    private final String identifier;
    protected final SpongePermissionService service;

    protected SpongeSubjectCollection(String identifier, SpongePermissionService service) {
        this.identifier = identifier;
        this.service = service;
    }

    @Override
    public String identifier() {
        return this.identifier;
    }

    @Override
    public Predicate<String> identifierValidityPredicate() {
        return s -> true;
    }

    @Override
    public SubjectReference newSubjectReference(String subjectIdentifier) {
        return this.service.newSubjectReference(this.identifier(), subjectIdentifier);
    }

    public abstract SpongeSubject get(String var1);

    public abstract boolean isRegistered(String var1);

    public CompletableFuture<Subject> loadSubject(String identifier) {
        return CompletableFuture.completedFuture(this.get(identifier));
    }

    public Optional<Subject> subject(String identifier) {
        return Optional.of(this.get(identifier));
    }

    @Override
    public CompletableFuture<Boolean> hasSubject(String identifier) {
        return CompletableFuture.completedFuture(this.isRegistered(identifier));
    }

    public CompletableFuture<Map<String, ? extends Subject>> loadSubjects(Iterable<String> identifiers) {
        HashMap<String, SpongeSubject> ret = new HashMap<String, SpongeSubject>();
        for (String id : identifiers) {
            ret.put(id, this.get(id));
        }
        return CompletableFuture.completedFuture(ImmutableMap.copyOf(ret));
    }

    public Map<Subject, Boolean> loadedWithPermission(String permission) {
        HashMap<Subject, Boolean> ret = new HashMap<Subject, Boolean>();
        for (Subject subject : this.loadedSubjects()) {
            Tristate state = subject.permissionValue(permission);
            if (state == Tristate.UNDEFINED) continue;
            ret.put(subject, state.asBoolean());
        }
        return Collections.unmodifiableMap(ret);
    }

    public Map<Subject, Boolean> loadedWithPermission(String permission, Cause cause) {
        HashMap<Subject, Boolean> ret = new HashMap<Subject, Boolean>();
        for (Subject subject : this.loadedSubjects()) {
            Tristate state = subject.permissionValue(permission, cause);
            if (state == Tristate.UNDEFINED) continue;
            ret.put(subject, state.asBoolean());
        }
        return Collections.unmodifiableMap(ret);
    }

    public CompletableFuture<Map<? extends SubjectReference, Boolean>> allWithPermission(String permission) {
        return CompletableFuture.completedFuture(this.loadedWithPermission(permission).entrySet().stream().collect(Collectors.toMap(e -> ((Subject)e.getKey()).asSubjectReference(), Map.Entry::getValue)));
    }

    public CompletableFuture<Map<? extends SubjectReference, Boolean>> allWithPermission(String permission, Cause cause) {
        return CompletableFuture.completedFuture(this.loadedWithPermission(permission, cause).entrySet().stream().collect(Collectors.toMap(e -> ((Subject)e.getKey()).asSubjectReference(), Map.Entry::getValue)));
    }

    public CompletableFuture<Set<String>> allIdentifiers() {
        return CompletableFuture.completedFuture((Set)this.loadedSubjects().stream().map(Contextual::identifier).collect(ImmutableSet.toImmutableSet()));
    }

    @Override
    public SpongeSubject defaults() {
        return this.service.getDefaultCollection().get(this.identifier());
    }

    @Override
    public void suggestUnload(String identifier) {
    }
}

