/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.util;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.Tag;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class NBTUtil {
    public static @Nullable Boolean getNullableBoolean(CompoundTag compound, String key) {
        Tag tag = compound.get(key);
        if (tag instanceof NumericTag) {
            return ((NumericTag)tag).getAsByte() != 0;
        }
        return null;
    }

    public static @Nullable CompoundTag getNullableCompound(CompoundTag compound, String key) {
        if (!compound.contains(key, 10)) {
            return null;
        }
        return compound.getCompound(key);
    }

    public static CompoundTag getOrCreateCompound(CompoundTag compound, String key) {
        if (!compound.contains(key, 10)) {
            CompoundTag child = new CompoundTag();
            compound.put(key, (Tag)child);
            return child;
        }
        return compound.getCompound(key);
    }

    private NBTUtil() {
    }
}

