/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world;

import java.util.function.Supplier;
import net.minecraft.world.level.dimension.DimensionType;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.world.WorldTypeEffect;
import org.spongepowered.common.AbstractResourceKeyed;
import org.spongepowered.common.registry.provider.DimensionEffectProvider;
import org.spongepowered.common.util.AbstractResourceKeyedBuilder;
import org.spongepowered.common.util.MemoizedSupplier;

public final class SpongeWorldTypeEffect
extends AbstractResourceKeyed
implements WorldTypeEffect {
    public SpongeWorldTypeEffect(ResourceKey key) {
        super(key);
        DimensionEffectProvider.INSTANCE.put(key, this);
    }

    public static final class FactoryImpl
    implements WorldTypeEffect.Factory {
        private static final Supplier<SpongeWorldTypeEffect> OVERWORLD = MemoizedSupplier.memoize(() -> new SpongeWorldTypeEffect((ResourceKey)DimensionType.OVERWORLD_EFFECTS));
        private static final Supplier<SpongeWorldTypeEffect> NETHER = MemoizedSupplier.memoize(() -> new SpongeWorldTypeEffect((ResourceKey)DimensionType.NETHER_EFFECTS));
        private static final Supplier<SpongeWorldTypeEffect> END = MemoizedSupplier.memoize(() -> new SpongeWorldTypeEffect((ResourceKey)DimensionType.END_EFFECTS));

        @Override
        public WorldTypeEffect overworld() {
            return OVERWORLD.get();
        }

        @Override
        public WorldTypeEffect nether() {
            return NETHER.get();
        }

        @Override
        public WorldTypeEffect end() {
            return END.get();
        }
    }

    public static final class BuilderImpl
    extends AbstractResourceKeyedBuilder<WorldTypeEffect, WorldTypeEffect.Builder>
    implements WorldTypeEffect.Builder {
        @Override
        protected WorldTypeEffect build0() {
            return new SpongeWorldTypeEffect(this.key);
        }
    }
}

