/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.portal;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.level.portal.PortalShape;
import net.minecraft.world.phys.Vec3;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.cause.entity.MovementType;
import org.spongepowered.api.event.cause.entity.MovementTypes;
import org.spongepowered.api.event.entity.ChangeEntityWorldEvent;
import org.spongepowered.api.util.Axis;
import org.spongepowered.api.world.portal.Portal;
import org.spongepowered.api.world.portal.PortalType;
import org.spongepowered.api.world.portal.PortalTypes;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.common.accessor.world.entity.EntityAccessor;
import org.spongepowered.common.bridge.world.entity.EntityBridge;
import org.spongepowered.common.util.AxisUtil;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.portal.PortalHelper;
import org.spongepowered.common.world.portal.PortalLogic;
import org.spongepowered.common.world.portal.VanillaPortal;
import org.spongepowered.common.world.portal.VanillaPortalType;
import org.spongepowered.common.world.portal.VanillaTwoDimensionalPortal;
import org.spongepowered.math.vector.Vector3d;

public final class NetherPortalType
extends VanillaPortalType {
    static Optional<BlockUtil.FoundRectangle> findPortalInternal(ServerLocation location) {
        ServerLevel serverWorld = (ServerLevel)location.world();
        BlockPos position = VecHelper.toBlockPos(location.blockPosition());
        return serverWorld.getPortalForcer().findPortalAround(position, serverWorld.dimension() == Level.NETHER);
    }

    public static Portal portalObjectFromRectangle(ServerWorld world, BlockUtil.FoundRectangle x) {
        Vector3d minCornerVec = VecHelper.toVector3d(x.minCorner);
        ServerLocation minCorner = (ServerLocation)world.location(minCornerVec);
        @Nullable Axis axis = minCorner.block().getOrNull(Keys.AXIS);
        if (axis == null) {
            return new VanillaPortal(PortalTypes.NETHER.get(), minCorner, null);
        }
        ServerLocation maxCorner = axis == Axis.X ? minCorner.withPosition(minCornerVec.add((float)x.axis1Size, (float)x.axis2Size, 0.0f)) : minCorner.withPosition(minCornerVec.add(0.0f, (float)x.axis2Size, (float)x.axis1Size));
        return new VanillaTwoDimensionalPortal(PortalTypes.NETHER.get(), minCorner, maxCorner, null);
    }

    @Override
    public boolean generatePortal(ServerLocation location, Axis axis) {
        Objects.requireNonNull(location);
        Direction.Axis mcAxis = AxisUtil.getFor(axis);
        if (mcAxis == Direction.Axis.Y) {
            mcAxis = Direction.Axis.X;
        }
        PortalHelper.generateNetherPortal((ServerLevel)location.world(), location.blockX(), location.blockY(), location.blockZ(), mcAxis, true);
        return true;
    }

    @Override
    public Optional<Portal> findPortal(ServerLocation location) {
        Objects.requireNonNull(location);
        return NetherPortalType.findPortalInternal(location).map(x -> NetherPortalType.portalObjectFromRectangle((ServerWorld)location.world(), x));
    }

    @Override
    public boolean teleport(Entity entity, ServerLocation destination, boolean generateDestinationPortal) {
        Objects.requireNonNull(entity);
        Objects.requireNonNull(destination);
        net.minecraft.world.entity.Entity mEntity = (net.minecraft.world.entity.Entity)entity;
        if (mEntity.isPassenger() || mEntity.isVehicle() || !mEntity.canChangeDimensions()) {
            return false;
        }
        Teleporter teleporter = new Teleporter(destination, generateDestinationPortal, this);
        ((EntityAccessor)((Object)entity)).accessor$portalEntrancePos(VecHelper.toBlockPos(entity.blockPosition()));
        return ((EntityBridge)((Object)entity)).bridge$changeDimension((ServerLevel)destination.world(), teleporter) != null;
    }

    static final class Teleporter
    implements PortalLogic {
        private final ServerLocation originalDestination;
        private final boolean generateDestinationPortal;
        private final PortalType portalType;

        public Teleporter(ServerLocation originalDestination, boolean generateDestinationPortal, PortalType type) {
            this.originalDestination = originalDestination;
            this.generateDestinationPortal = generateDestinationPortal;
            this.portalType = type;
        }

        @Override
        public @Nullable PortalInfo getPortalInfo(net.minecraft.world.entity.Entity entity, ServerLevel targetWorld, Function<ServerLevel, PortalInfo> defaultPortalInfo) {
            Optional<PortalInfo> portal = NetherPortalType.findPortalInternal(this.originalDestination).map(x -> this.createNetherPortalInfo(entity, targetWorld, x.minCorner, (BlockUtil.FoundRectangle)x));
            Vector3d originalDestination = portal.map(x -> VecHelper.toVector3d(x.pos)).orElseGet(this.originalDestination::position);
            ChangeEntityWorldEvent.Reposition reposition = ((EntityBridge)entity).bridge$fireRepositionEvent((ServerWorld)this.originalDestination.world(), (ServerWorld)targetWorld, originalDestination);
            if (!reposition.isCancelled() && reposition.destinationPosition() != originalDestination) {
                portal = NetherPortalType.findPortalInternal(this.originalDestination.withPosition(reposition.destinationPosition())).map(x -> this.createNetherPortalInfo(entity, targetWorld, x.minCorner, (BlockUtil.FoundRectangle)x));
            }
            if (this.generateDestinationPortal && !portal.isPresent()) {
                return targetWorld.getPortalForcer().createPortal(VecHelper.toBlockPos(this.originalDestination), Direction.from2DDataValue((int)entity.getDirection().get2DDataValue()).getAxis()).map(x -> this.createNetherPortalInfo(entity, targetWorld, x.minCorner, (BlockUtil.FoundRectangle)x)).orElse(null);
            }
            return portal.orElse(null);
        }

        @Override
        public net.minecraft.world.entity.Entity placeEntity(net.minecraft.world.entity.Entity entity, ServerLevel currentWorld, ServerLevel targetWorld, float yRot, Function<Boolean, net.minecraft.world.entity.Entity> teleportLogic) {
            return teleportLogic.apply(false);
        }

        @Override
        public boolean isVanilla() {
            return false;
        }

        @Override
        public MovementType getMovementType() {
            return MovementTypes.PORTAL.get();
        }

        @Override
        public PortalType getPortalType() {
            return this.portalType;
        }

        private PortalInfo createNetherPortalInfo(net.minecraft.world.entity.Entity entity, ServerLevel serverWorld, BlockPos portalLocation, BlockUtil.FoundRectangle result) {
            Vec3 vector3d;
            Direction.Axis axis;
            BlockState blockstate = serverWorld.getBlockState(portalLocation);
            if (blockstate.hasProperty((Property)BlockStateProperties.HORIZONTAL_AXIS)) {
                axis = (Direction.Axis)blockstate.getValue((Property)BlockStateProperties.HORIZONTAL_AXIS);
                BlockUtil.FoundRectangle res = BlockUtil.getLargestRectangleAround((BlockPos)portalLocation, (Direction.Axis)axis, (int)21, (Direction.Axis)Direction.Axis.Y, (int)21, pos -> serverWorld.getBlockState(pos) == blockstate);
                vector3d = PortalShape.getRelativePosition((BlockUtil.FoundRectangle)res, (Direction.Axis)axis, (Vec3)entity.position(), (EntityDimensions)entity.getDimensions(entity.getPose()));
            } else {
                axis = Direction.Axis.X;
                vector3d = new Vec3(0.5, 0.0, 0.0);
            }
            return PortalShape.createPortalInfo((ServerLevel)serverWorld, (BlockUtil.FoundRectangle)result, (Direction.Axis)axis, (Vec3)vector3d, (EntityDimensions)entity.getDimensions(entity.getPose()), (Vec3)entity.getDeltaMovement(), (float)entity.yRot, (float)entity.xRot);
        }
    }
}

