/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.volume.buffer.archetype;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.entity.BlockEntityArchetype;
import org.spongepowered.api.entity.EntityArchetype;
import org.spongepowered.api.fluid.FluidState;
import org.spongepowered.api.registry.DefaultedRegistryReference;
import org.spongepowered.api.util.Axis;
import org.spongepowered.api.util.mirror.Mirror;
import org.spongepowered.api.util.mirror.Mirrors;
import org.spongepowered.api.util.rotation.Rotation;
import org.spongepowered.api.util.transformation.Transformation;
import org.spongepowered.api.world.biome.Biome;
import org.spongepowered.api.world.volume.Volume;
import org.spongepowered.api.world.volume.archetype.ArchetypeVolume;
import org.spongepowered.api.world.volume.archetype.block.entity.BlockEntityArchetypeVolume;
import org.spongepowered.api.world.volume.archetype.entity.EntityArchetypeEntry;
import org.spongepowered.api.world.volume.archetype.entity.EntityArchetypeVolume;
import org.spongepowered.api.world.volume.biome.BiomeVolume;
import org.spongepowered.api.world.volume.block.BlockVolume;
import org.spongepowered.api.world.volume.stream.StreamOptions;
import org.spongepowered.api.world.volume.stream.VolumeElement;
import org.spongepowered.api.world.volume.stream.VolumePositionTranslators;
import org.spongepowered.api.world.volume.stream.VolumeStream;
import org.spongepowered.common.util.MemoizedSupplier;
import org.spongepowered.common.world.volume.VolumeStreamUtils;
import org.spongepowered.common.world.volume.buffer.archetype.ReferentArchetypeVolume;
import org.spongepowered.math.vector.Vector3d;
import org.spongepowered.math.vector.Vector3i;

public class AbstractReferentArchetypeVolume<A extends ArchetypeVolume>
implements ArchetypeVolume {
    protected final Supplier<A> reference;
    protected final Transformation transformation;

    protected AbstractReferentArchetypeVolume(Supplier<A> reference, Transformation transformation) {
        this.reference = MemoizedSupplier.memoize(reference);
        this.transformation = transformation;
    }

    public final Transformation transformation() {
        return this.transformation;
    }

    protected <T> T applyReference(Function<A, T> function) {
        @Nullable ArchetypeVolume archetypeVolume = (ArchetypeVolume)this.reference.get();
        Objects.requireNonNull(archetypeVolume, "ArchetypeVolume reference lost");
        return function.apply(archetypeVolume);
    }

    protected void consumeReference(Consumer<A> function) {
        @Nullable ArchetypeVolume archetypeVolume = (ArchetypeVolume)this.reference.get();
        Objects.requireNonNull(archetypeVolume, "ArchetypeVolume reference lost");
        function.accept(archetypeVolume);
    }

    public Vector3i inverseTransform(double x, double y, double z) {
        return this.transformation.inverse().transformPosition(new Vector3d(x, y, z)).toInt();
    }

    protected Vector3i transformBlockSizes(Vector3i min, Vector3i max, BiFunction<Vector3i, Vector3i, Vector3i> minmax) {
        Vector3d rawBlockMin = min.toDouble().add(VolumePositionTranslators.BLOCK_OFFSET);
        Vector3i transformedMin = this.transformation.transformPosition(rawBlockMin).sub(VolumePositionTranslators.BLOCK_OFFSET).toInt();
        Vector3d rawBlockMax = max.toDouble().add(VolumePositionTranslators.BLOCK_OFFSET);
        Vector3i transformedMax = this.transformation.transformPosition(rawBlockMax).sub(VolumePositionTranslators.BLOCK_OFFSET).toInt();
        return minmax.apply(transformedMin, transformedMax);
    }

    protected Vector3i transformBlockSize(BiFunction<Vector3i, Vector3i, Vector3i> minmax) {
        return this.applyReference(a -> this.transformBlockSizes(a.min(), a.max(), minmax));
    }

    protected Vector3d transformStreamBlockPosition(Vector3d blockPosition) {
        return this.transformation.transformPosition(blockPosition);
    }

    @Override
    public Vector3i min() {
        return this.transformBlockSize(Vector3i::min);
    }

    @Override
    public Vector3i max() {
        return this.transformBlockSize(Vector3i::max);
    }

    @Override
    public Vector3i size() {
        return this.applyReference(Volume::size);
    }

    @Override
    public boolean contains(int x, int y, int z) {
        Vector3i transformed = this.inverseTransform(x, y, z);
        return this.applyReference(a -> a.contains(transformed.x(), transformed.y(), transformed.z()));
    }

    @Override
    public boolean isAreaAvailable(int x, int y, int z) {
        Vector3i transformed = this.inverseTransform(x, y, z);
        return this.applyReference(a -> a.isAreaAvailable(transformed.x(), transformed.y(), transformed.z()));
    }

    @Override
    public ArchetypeVolume transform(Transformation transformation) {
        return new ReferentArchetypeVolume(this, Objects.requireNonNull(transformation, "Transformation cannot be null"));
    }

    @Override
    public Optional<BlockEntityArchetype> blockEntityArchetype(int x, int y, int z) {
        Vector3i transformed = this.inverseTransform(x, y, z);
        return this.applyReference(a -> a.blockEntityArchetype(transformed.x(), transformed.y(), transformed.z()));
    }

    @Override
    public Map<Vector3i, BlockEntityArchetype> blockEntityArchetypes() {
        return this.applyReference(a -> a.blockEntityArchetypes().entrySet().stream().collect(Collectors.toMap(e -> this.transformation.transformPosition(((Vector3i)e.getKey()).toDouble()).toInt(), Map.Entry::getValue)));
    }

    @Override
    public VolumeStream<ArchetypeVolume, BlockEntityArchetype> blockEntityArchetypeStream(Vector3i min, Vector3i max, StreamOptions options) {
        return this.applyTransformationsToStream(min, max, options, BlockEntityArchetypeVolume.Streamable::blockEntityArchetypeStream, (e, rotation, mirror) -> (BlockEntityArchetype)e.type());
    }

    @Override
    public void addBlockEntity(int x, int y, int z, BlockEntityArchetype archetype) {
        Vector3i transformed = this.inverseTransform(x, y, z);
        this.consumeReference(a -> a.addBlockEntity(transformed.x(), transformed.y(), transformed.z(), archetype));
    }

    @Override
    public void removeBlockEntity(int x, int y, int z) {
        Vector3i transformed = this.inverseTransform(x, y, z);
        this.consumeReference(a -> a.removeBlockEntity(transformed.x(), transformed.y(), transformed.z()));
    }

    @Override
    public Collection<EntityArchetype> entityArchetypes() {
        return this.applyReference(EntityArchetypeVolume::entityArchetypes);
    }

    @Override
    public Collection<EntityArchetypeEntry> entityArchetypesByPosition() {
        return this.applyReference(a -> a.entityArchetypesByPosition().stream().map(e -> EntityArchetypeEntry.of(e.archetype(), this.transformation.transformPosition(e.position()))).collect(Collectors.toList()));
    }

    @Override
    public Collection<EntityArchetype> entityArchetypes(Predicate<EntityArchetype> filter) {
        return this.applyReference(e -> e.entityArchetypes(filter));
    }

    @Override
    public VolumeStream<ArchetypeVolume, EntityArchetype> entityArchetypeStream(Vector3i min, Vector3i max, StreamOptions options) {
        return this.applyTransformationsToStream(min, max, options, EntityArchetypeVolume.Streamable::entityArchetypeStream, (e, rotation, mirror) -> (EntityArchetype)e.type());
    }

    @Override
    public Stream<EntityArchetypeEntry> entitiesByPosition() {
        return this.applyReference(a -> a.entityArchetypesByPosition().stream().map(e -> EntityArchetypeEntry.of(e.archetype(), this.transformation.transformPosition(e.position()))));
    }

    @Override
    public void addEntity(EntityArchetypeEntry entry) {
        Vector3d position = entry.position();
        Vector3i transformed = this.inverseTransform(position.x(), position.y(), position.z());
        this.consumeReference(a -> a.addEntity(entry.archetype(), transformed.toDouble()));
    }

    @Override
    public Biome biome(int x, int y, int z) {
        Vector3i transformed = this.inverseTransform(x, y, z);
        return this.applyReference(a -> a.biome(transformed.x(), transformed.y(), transformed.z()));
    }

    @Override
    public VolumeStream<ArchetypeVolume, Biome> biomeStream(Vector3i min, Vector3i max, StreamOptions options) {
        return this.applyTransformationsToStream(min, max, options, BiomeVolume.Streamable::biomeStream, (e, rotation, mirror) -> (Biome)e.type());
    }

    @Override
    public boolean setBiome(int x, int y, int z, Biome biome) {
        Vector3i transformed = this.inverseTransform(x, y, z);
        return this.applyReference(a -> a.setBiome(transformed.x(), transformed.y(), transformed.z(), biome));
    }

    @Override
    public BlockState block(int x, int y, int z) {
        Vector3i transformed = this.inverseTransform(x, y, z);
        return this.applyReference(a -> a.block(transformed.x(), transformed.y(), transformed.z()));
    }

    @Override
    public FluidState fluid(int x, int y, int z) {
        Vector3i transformed = this.inverseTransform(x, y, z);
        return this.applyReference(a -> a.fluid(transformed.x(), transformed.y(), transformed.z()));
    }

    @Override
    public int highestYAt(int x, int z) {
        Vector3i transformed = this.inverseTransform(x, 0.0, z);
        return this.applyReference(a -> a.highestYAt(transformed.x(), transformed.z()));
    }

    @Override
    public VolumeStream<ArchetypeVolume, BlockState> blockStateStream(Vector3i min, Vector3i max, StreamOptions options) {
        return this.applyTransformationsToStream(min, max, options, BlockVolume.Streamable::blockStateStream, (e, rotation, mirror) -> ((BlockState)e.type()).mirror((Supplier<? extends Mirror>)mirror).rotate((Supplier<? extends Rotation>)rotation));
    }

    @Override
    public boolean setBlock(int x, int y, int z, BlockState block) {
        Vector3i transformed = this.inverseTransform(x, y, z);
        return this.applyReference(a -> a.setBlock(transformed.x(), transformed.y(), transformed.z(), block));
    }

    @Override
    public boolean removeBlock(int x, int y, int z) {
        Vector3i transformed = this.inverseTransform(x, y, z);
        return this.applyReference(a -> a.removeBlock(transformed.x(), transformed.y(), transformed.z()));
    }

    private <T> VolumeStream<ArchetypeVolume, T> applyTransformationsToStream(Vector3i min, Vector3i max, StreamOptions options, StreamCreator<A, T> streamCreator, VolumeStreamUtils.TriFunction<VolumeElement<ArchetypeVolume, T>, Supplier<Rotation>, Supplier<Mirror>, T> elementTransform) {
        Vector3i transformedMin = this.min();
        Vector3i transformedMax = this.max();
        VolumeStreamUtils.validateStreamArgs(min, max, transformedMin, transformedMax, options);
        Vector3i minDiff = min.sub(transformedMin);
        Vector3i maxDiff = transformedMax.sub(max);
        boolean xMirror = this.transformation.mirror(Axis.X);
        boolean zMirror = this.transformation.mirror(Axis.Z);
        DefaultedRegistryReference<Mirror> mirror = xMirror ? Mirrors.FRONT_BACK : (zMirror ? Mirrors.LEFT_RIGHT : Mirrors.NONE);
        return this.applyReference(a -> streamCreator.createStream(a, a.min().add(minDiff), a.max().sub(maxDiff), options)).transform((VolumeElement<V, T> e) -> VolumeElement.of(this, elementTransform.apply(e, this.transformation::rotation, mirror), this.transformStreamBlockPosition(e.position().add(VolumePositionTranslators.BLOCK_OFFSET)).sub(VolumePositionTranslators.BLOCK_OFFSET)));
    }

    protected static interface StreamCreator<TA extends Volume, SE> {
        public VolumeStream<ArchetypeVolume, SE> createStream(TA var1, Vector3i var2, Vector3i var3, StreamOptions var4);
    }
}

