/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.vanilla.applaunch.handler;

import cpw.mods.gross.Java9ClassLoaderUtil;
import cpw.mods.modlauncher.api.ILaunchHandlerService;
import cpw.mods.modlauncher.api.ITransformingClassLoader;
import cpw.mods.modlauncher.api.ITransformingClassLoaderBuilder;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.common.applaunch.AppLaunch;
import org.spongepowered.plugin.PluginResource;
import org.spongepowered.plugin.builtin.jvm.locator.JVMPluginResource;
import org.spongepowered.plugin.builtin.jvm.locator.ResourceType;
import org.spongepowered.vanilla.applaunch.plugin.VanillaPluginPlatform;

public abstract class AbstractVanillaLaunchHandler
implements ILaunchHandlerService {
    private static final String JAVA_HOME_PATH = System.getProperty("java.home");
    protected final Logger logger = LogManager.getLogger((String)"launch");
    protected static final String[] NON_TRANSFORMABLE_PATHS = new String[]{"org/spongepowered/asm/", "org/slf4j/impl/"};
    private static final String[] EXCLUDED_PACKAGES = new String[]{"org.spongepowered.plugin.", "org.spongepowered.common.applaunch.", "org.spongepowered.vanilla.applaunch.", "io.leangen.geantyref.", "org.spongepowered.configurate.", "org.jline.", "org.fusesource.", "net.minecrell.terminalconsole.", "org.slf4j.", "org.apache.maven.artifact."};
    private static final String[] EXCLUSION_EXCEPTIONS = new String[]{"org.spongepowered.configurate.objectmapping.guice.", "org.spongepowered.configurate.yaml.", "org.spongepowered.configurate.gson.", "org.spongepowered.configurate.jackson.", "org.spongepowered.configurate.xml."};
    private final ConcurrentMap<URL, Optional<Manifest>> manifestCache = new ConcurrentHashMap<URL, Optional<Manifest>>();
    private static final Optional<Manifest> UNKNOWN_MANIFEST = Optional.of(new Manifest());

    public void configureTransformationClassLoader(ITransformingClassLoaderBuilder builder) {
        VanillaPluginPlatform platform = (VanillaPluginPlatform)AppLaunch.pluginPlatform();
        for (Path path : (List)platform.getStandardEnvironment().blackboard().getOrCreate(VanillaPluginPlatform.EXTRA_TRANSFORMABLE_PATHS, () -> Collections.emptyList())) {
            builder.addTransformationPath(path);
        }
        for (URL url : Java9ClassLoaderUtil.getSystemClassPathURLs()) {
            try {
                URI uri = url.toURI();
                if (!this.isTransformable(uri)) {
                    this.logger.debug("Non-transformable system classpath entry: {}", (Object)uri);
                    continue;
                }
                builder.addTransformationPath(Paths.get(uri));
                this.logger.debug("Transformable system classpath entry: {}", (Object)uri);
            }
            catch (IOException | URISyntaxException ex) {
                this.logger.error("Failed to add {} to transformation path", (Object)url, (Object)ex);
            }
        }
        builder.setResourceEnumeratorLocator(this.getResourceLocator());
        builder.setManifestLocator(this.getManifestLocator());
    }

    protected boolean isTransformable(URI uri) throws URISyntaxException, IOException {
        File file = new File(uri);
        if (file.getAbsolutePath().startsWith(JAVA_HOME_PATH)) {
            return false;
        }
        if (file.isDirectory()) {
            for (String test : NON_TRANSFORMABLE_PATHS) {
                if (!new File(file, test).exists()) continue;
                return false;
            }
        } else if (file.isFile()) {
            try (JarFile jf = new JarFile(new File(uri));){
                for (String test : NON_TRANSFORMABLE_PATHS) {
                    if (jf.getEntry(test) == null) continue;
                    boolean bl = false;
                    return bl;
                }
            }
        }
        return true;
    }

    public Callable<Void> launchService(String[] arguments, ITransformingClassLoader launchClassLoader) {
        this.logger.info("Transitioning to Sponge launch, please wait...");
        launchClassLoader.addTargetPackageFilter(klass -> {
            block0: for (String pkg : EXCLUDED_PACKAGES) {
                if (!klass.startsWith(pkg)) continue;
                for (String exception : EXCLUSION_EXCEPTIONS) {
                    if (klass.startsWith(exception)) break block0;
                }
                return false;
            }
            return true;
        });
        AbstractVanillaLaunchHandler.fixPackageExclusions(launchClassLoader);
        return () -> {
            this.launchService0(arguments, launchClassLoader);
            return null;
        };
    }

    private static void fixPackageExclusions(ITransformingClassLoader tcl) {
        try {
            Field prefixField = tcl.getClass().getDeclaredField("SKIP_PACKAGE_PREFIXES");
            prefixField.setAccessible(true);
            ((List)prefixField.get(null)).set(1, "__javax__noplswhy.");
        }
        catch (IllegalAccessException | NoSuchFieldException ex) {
            throw new RuntimeException("Failed to fix strange transformer exclusions", ex);
        }
    }

    protected Function<String, Enumeration<URL>> getResourceLocator() {
        return s -> {
            URI asUri;
            if (s.startsWith("net/minecraft") || s.startsWith("it/unimi")) {
                return Collections.emptyEnumeration();
            }
            try {
                asUri = new URI(null, null, (String)s, null);
            }
            catch (URISyntaxException ex) {
                this.logger.error("Failed to convert resource path {} to a URI", s, (Object)ex);
                return Collections.emptyEnumeration();
            }
            return new Enumeration<URL>(){
                URL next;
                final Iterator serviceResources = ((VanillaPluginPlatform)AppLaunch.pluginPlatform()).getResources().values().iterator();
                Iterator resources;
                {
                    this.next = this.computeNext();
                }

                @Override
                public boolean hasMoreElements() {
                    return this.next != null;
                }

                @Override
                public URL nextElement() {
                    URL next = this.next;
                    if (next == null) {
                        throw new NoSuchElementException();
                    }
                    this.next = this.computeNext();
                    return next;
                }

                private URL computeNext() {
                    Optional uri;
                    PluginResource resource;
                    do {
                        if (this.resources != null && !this.resources.hasNext()) {
                            this.resources = null;
                        }
                        if (this.resources != null) continue;
                        if (!this.serviceResources.hasNext()) {
                            return null;
                        }
                        this.resources = ((Set)this.serviceResources.next()).iterator();
                    } while (!this.resources.hasNext() || (resource = (PluginResource)this.resources.next()) instanceof JVMPluginResource && ((JVMPluginResource)resource).type() != ResourceType.JAR || !(uri = resource.locateResource(asUri)).isPresent());
                    try {
                        return ((URI)uri.get()).toURL();
                    }
                    catch (MalformedURLException ex) {
                        throw new RuntimeException(ex);
                    }
                }
            };
        };
    }

    private Function<URLConnection, Optional<Manifest>> getManifestLocator() {
        return connection -> {
            if (connection instanceof JarURLConnection) {
                URL jarFileUrl = ((JarURLConnection)connection).getJarFileURL();
                Optional manifest = this.manifestCache.computeIfAbsent(jarFileUrl, key -> {
                    for (Set<PluginResource> resources : ((VanillaPluginPlatform)AppLaunch.pluginPlatform()).getResources().values()) {
                        for (PluginResource resource : resources) {
                            if (!(resource instanceof JVMPluginResource)) continue;
                            JVMPluginResource jvmResource = (JVMPluginResource)resource;
                            try {
                                if (jvmResource.type() != ResourceType.JAR || !((JVMPluginResource)resource).path().toAbsolutePath().normalize().equals(Paths.get(key.toURI()).toAbsolutePath().normalize())) continue;
                                return jvmResource.manifest();
                            }
                            catch (URISyntaxException ex) {
                                this.logger.error("Failed to load manifest from jar {}: ", key, (Object)ex);
                            }
                        }
                    }
                    return UNKNOWN_MANIFEST;
                });
                try {
                    if (manifest == UNKNOWN_MANIFEST) {
                        return Optional.ofNullable(((JarURLConnection)connection).getManifest());
                    }
                    return manifest;
                }
                catch (IOException ex) {
                    this.logger.error("Failed to load manifest from jar {}: ", (Object)jarFileUrl, (Object)ex);
                }
            }
            return Optional.empty();
        };
    }

    protected abstract void launchService0(String[] var1, ITransformingClassLoader var2) throws Exception;
}

