/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.vanilla.mixin.core.server.network;

import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.game.ServerGamePacketListener;
import net.minecraft.network.protocol.game.ServerboundCustomPayloadPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.item.crafting.Recipe;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.crafting.CraftingInventory;
import org.spongepowered.api.item.inventory.query.QueryTypes;
import org.spongepowered.api.network.EngineConnection;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.accessor.network.protocol.game.ServerboundCustomPayloadPacketAccessor;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.context.transaction.EffectTransactor;
import org.spongepowered.common.event.tracking.context.transaction.TransactionalCaptureSupplier;
import org.spongepowered.common.network.channel.SpongeChannelManager;
import org.spongepowered.vanilla.chat.ChatFormatter;

@Mixin(value={ServerGamePacketListenerImpl.class}, priority=999)
public abstract class ServerGamePacketListenerImplMixin_Vanilla
implements ServerGamePacketListener {
    @Shadow
    @Final
    private MinecraftServer server;

    @Inject(method={"handleCustomPayload"}, at={@At(value="HEAD")})
    private void vanilla$onHandleCustomPayload(ServerboundCustomPayloadPacket packet, CallbackInfo ci) {
        ((ServerboundCustomPayloadPacketAccessor)packet).accessor$data().retain();
        SpongeChannelManager channelRegistry = (SpongeChannelManager)Sponge.channelManager();
        this.server.execute(() -> channelRegistry.handlePlayPayload((EngineConnection)((Object)this), packet));
    }

    @Inject(method={"handleChat(Ljava/lang/String;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/players/PlayerList;broadcastMessage(Lnet/minecraft/network/chat/Component;Lnet/minecraft/network/chat/ChatType;Ljava/util/UUID;)V")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void vanilla$onProcessChatMessage(String var1, CallbackInfo ci, Component component) {
        ChatFormatter.formatChatComponent((TranslatableComponent)component);
    }

    @Redirect(method={"lambda$handlePlaceRecipe$10"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/inventory/RecipeBookMenu;handlePlacement(ZLnet/minecraft/world/item/crafting/Recipe;Lnet/minecraft/server/level/ServerPlayer;)V"))
    private void vanilla$onPlaceRecipe(RecipeBookMenu recipeBookMenu, boolean shift, Recipe<?> recipe, ServerPlayer player) {
        PhaseContext<@NonNull ?> context = PhaseTracker.SERVER.getPhaseContext();
        TransactionalCaptureSupplier transactor = context.getTransactor();
        Inventory craftInv = ((Inventory)player.containerMenu).query(QueryTypes.INVENTORY_TYPE.get().of(CraftingInventory.class));
        if (!(craftInv instanceof CraftingInventory)) {
            recipeBookMenu.handlePlacement(shift, recipe, player);
            SpongeCommon.logger().warn("Detected crafting without a InventoryCrafting!? Crafting Event will not fire.");
            return;
        }
        try (EffectTransactor ignored = transactor.logPlaceRecipe(shift, recipe, player, (CraftingInventory)craftInv);){
            recipeBookMenu.handlePlacement(shift, recipe, player);
            player.containerMenu.broadcastChanges();
        }
    }
}

