/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.vanilla.mixin.core.world.level.portal;

import java.util.function.Function;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.portal.PortalForcer;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.phys.Vec3;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.event.cause.entity.MovementType;
import org.spongepowered.api.event.cause.entity.MovementTypes;
import org.spongepowered.api.world.portal.PortalType;
import org.spongepowered.api.world.portal.PortalTypes;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.common.world.portal.PortalLogic;

@Mixin(value={PortalForcer.class})
public abstract class PortalForcerMixin_Vanilla
implements PortalLogic {
    @Override
    public @Nullable PortalInfo getPortalInfo(Entity entity, ServerLevel targetWorld, Function<ServerLevel, PortalInfo> defaultPortalInfo) {
        return this.isVanilla() ? defaultPortalInfo.apply(targetWorld) : new PortalInfo(entity.position(), Vec3.ZERO, entity.yRot, entity.xRot);
    }

    @Override
    public @Nullable Entity placeEntity(Entity entity, ServerLevel currentWorld, ServerLevel targetWorld, float yRot, Function<Boolean, Entity> teleportLogic) {
        return teleportLogic.apply(true);
    }

    @Override
    public boolean isVanilla() {
        return this.getClass().equals(PortalForcer.class);
    }

    @Override
    public MovementType getMovementType() {
        return MovementTypes.PORTAL.get();
    }

    @Override
    public PortalType getPortalType() {
        return PortalTypes.NETHER.get();
    }
}

