/*
 * Decompiled with CFR 0.152.
 */
package org.tinylog.pattern;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.tinylog.core.LogEntry;
import org.tinylog.core.LogEntryValue;
import org.tinylog.pattern.Token;
import org.tinylog.throwable.ThrowableData;
import org.tinylog.throwable.ThrowableFilter;
import org.tinylog.throwable.ThrowableWrapper;

final class ExceptionToken
implements Token {
    private static final String NEW_LINE = System.getProperty("line.separator");
    private final List<ThrowableFilter> filters;

    ExceptionToken(List<ThrowableFilter> filters) {
        this.filters = filters;
    }

    @Override
    public Collection<LogEntryValue> getRequiredLogEntryValues() {
        return Collections.singleton(LogEntryValue.EXCEPTION);
    }

    @Override
    public void render(LogEntry logEntry, StringBuilder builder) {
        Throwable throwable = logEntry.getException();
        if (throwable != null) {
            this.render(this.filter(throwable), Collections.<StackTraceElement>emptyList(), builder);
        }
    }

    @Override
    public void apply(LogEntry logEntry, PreparedStatement statement, int index) throws SQLException {
        Throwable throwable = logEntry.getException();
        if (throwable == null) {
            statement.setString(index, null);
        } else {
            StringBuilder builder = new StringBuilder();
            this.render(this.filter(throwable), Collections.<StackTraceElement>emptyList(), builder);
            statement.setString(index, builder.toString());
        }
    }

    private ThrowableData filter(Throwable throwable) {
        ThrowableData data = new ThrowableWrapper(throwable);
        for (ThrowableFilter filter : this.filters) {
            data = filter.filter(data);
        }
        return data;
    }

    private void render(ThrowableData throwable, List<StackTraceElement> parentTrace, StringBuilder builder) {
        ThrowableData cause;
        List<StackTraceElement> stackTrace = throwable.getStackTrace();
        int parentIndex = parentTrace.size() - 1;
        int childIndex = stackTrace.size() - 1;
        int commonElements = 0;
        while (parentIndex >= 0 && childIndex >= 0 && parentTrace.get(parentIndex).equals(stackTrace.get(childIndex))) {
            --parentIndex;
            --childIndex;
            ++commonElements;
        }
        builder.append(throwable.getClassName());
        String message = throwable.getMessage();
        if (message != null) {
            builder.append(": ");
            builder.append(message);
        }
        for (int i = 0; i < stackTrace.size() - commonElements; ++i) {
            builder.append(NEW_LINE);
            builder.append("\tat ");
            builder.append(stackTrace.get(i));
        }
        if (commonElements > 0) {
            builder.append(NEW_LINE);
            builder.append("\t... ");
            builder.append(commonElements);
            builder.append(" more");
        }
        if ((cause = throwable.getCause()) != null) {
            builder.append(NEW_LINE);
            builder.append("Caused by: ");
            this.render(cause, stackTrace, builder);
        }
    }
}

