/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.network.channel.raw.play;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.network.EngineConnection;
import org.spongepowered.api.network.EngineConnectionSide;
import org.spongepowered.api.network.channel.ChannelBuf;
import org.spongepowered.api.network.channel.raw.RawDataChannel;
import org.spongepowered.api.network.channel.raw.play.RawPlayDataHandler;
import org.spongepowered.api.world.server.ServerWorld;

public interface RawPlayDataChannel {
    public RawDataChannel parent();

    public boolean isSupportedBy(EngineConnection var1);

    public void addHandler(RawPlayDataHandler<EngineConnection> var1);

    public <C extends EngineConnection> void addHandler(EngineConnectionSide<C> var1, RawPlayDataHandler<? super C> var2);

    public <C extends EngineConnection> void addHandler(Class<C> var1, RawPlayDataHandler<? super C> var2);

    public <C extends EngineConnection> void removeHandler(EngineConnectionSide<C> var1, RawPlayDataHandler<? super C> var2);

    public <C extends EngineConnection> void removeHandler(Class<C> var1, RawPlayDataHandler<? super C> var2);

    public void removeHandler(RawPlayDataHandler<?> var1);

    default public void sendToAllPlayers(Consumer<ChannelBuf> payload) {
        Sponge.server().onlinePlayers().forEach(player -> this.sendTo((ServerPlayer)player, payload));
    }

    default public void sendToAllPlayersIn(ServerWorld world, Consumer<ChannelBuf> payload) {
        world.players().forEach(player -> this.sendTo((ServerPlayer)player, payload));
    }

    default public CompletableFuture<Void> sendTo(ServerPlayer player, Consumer<ChannelBuf> payload) {
        return this.sendTo(player.connection(), payload);
    }

    default public CompletableFuture<Void> sendToServer(Consumer<ChannelBuf> payload) {
        EngineConnection connection = Sponge.client().connection().orElseThrow(() -> new IllegalStateException("The client is currently not connected to a server."));
        return this.sendTo(connection, payload);
    }

    public CompletableFuture<Void> sendTo(EngineConnection var1, Consumer<ChannelBuf> var2);
}

