/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.service.permission;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.service.permission.PermissionDescription;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.service.permission.SubjectCollection;
import org.spongepowered.api.service.permission.SubjectData;
import org.spongepowered.api.service.permission.SubjectReference;
import org.spongepowered.plugin.PluginContainer;

public interface PermissionService {
    public static final String SUBJECTS_USER = "user";
    public static final String SUBJECTS_GROUP = "group";
    public static final String SUBJECTS_SYSTEM = "system";
    public static final String SUBJECTS_DEFAULT = "defaults";
    public static final String SUBJECTS_COMMAND_BLOCK = "commandblock";
    public static final String SUBJECTS_ROLE_TEMPLATE = "role-template";

    public SubjectCollection userSubjects();

    public SubjectCollection groupSubjects();

    public Subject defaults();

    default public Optional<? extends SubjectData> roleTemplate(PluginContainer plugin, String roleTemplate) {
        Objects.requireNonNull(plugin, "plugin");
        return this.collection(SUBJECTS_ROLE_TEMPLATE).flatMap(coll -> coll.subject(plugin.metadata().id() + ":" + Objects.requireNonNull(roleTemplate, "roleTemplate"))).map(Subject::transientSubjectData);
    }

    default public Set<? extends Map.Entry<PluginContainer, ? extends SubjectData>> roleTemplates(String roleTemplate) {
        Optional<? extends SubjectCollection> coll = this.collection(SUBJECTS_ROLE_TEMPLATE);
        if (!coll.isPresent()) {
            return Collections.emptySet();
        }
        Optional<? extends Subject> globalSubj = coll.get().subject(Objects.requireNonNull(roleTemplate, "roleTemplate"));
        if (!globalSubj.isPresent()) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(globalSubj.get().transientSubjectData().parents(SubjectData.GLOBAL_CONTEXT).stream().map(SubjectReference::resolve).map(CompletableFuture::join).map(it -> {
            String[] name = it.identifier().split(":", 2);
            if (name.length < 2) {
                return null;
            }
            Optional<PluginContainer> container = Sponge.pluginManager().plugin(name[0]);
            if (!container.isPresent()) {
                return null;
            }
            return new AbstractMap.SimpleImmutableEntry<PluginContainer, SubjectData>(container.get(), it.transientSubjectData());
        }).filter(Objects::nonNull).collect(Collectors.toSet()));
    }

    public Predicate<String> identifierValidityPredicate();

    public CompletableFuture<? extends SubjectCollection> loadCollection(String var1);

    public Optional<? extends SubjectCollection> collection(String var1);

    public CompletableFuture<Boolean> hasCollection(String var1);

    public Map<String, ? extends SubjectCollection> loadedCollections();

    public CompletableFuture<? extends Set<String>> allIdentifiers();

    public SubjectReference newSubjectReference(String var1, String var2);

    public PermissionDescription.Builder newDescriptionBuilder(PluginContainer var1);

    public Optional<? extends PermissionDescription> description(String var1);

    public Collection<? extends PermissionDescription> descriptions();
}

