/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world;

import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.datapack.DataPackSerializable;
import org.spongepowered.api.util.CopyableBuilder;
import org.spongepowered.api.util.MinecraftDayTime;
import org.spongepowered.api.util.ResourceKeyedBuilder;
import org.spongepowered.api.world.WorldTypeEffect;
import org.spongepowered.api.world.biome.BiomeSampler;

public interface WorldTypeTemplate
extends DataPackSerializable {
    public static WorldTypeTemplate overworld() {
        return Sponge.game().factoryProvider().provide(Factory.class).overworld();
    }

    public static WorldTypeTemplate overworldCaves() {
        return Sponge.game().factoryProvider().provide(Factory.class).overworldCaves();
    }

    public static WorldTypeTemplate theNether() {
        return Sponge.game().factoryProvider().provide(Factory.class).theNether();
    }

    public static WorldTypeTemplate theEnd() {
        return Sponge.game().factoryProvider().provide(Factory.class).theEnd();
    }

    public static Builder builder() {
        return (Builder)Sponge.game().builderProvider().provide(Builder.class).reset();
    }

    public WorldTypeEffect effect();

    public BiomeSampler biomeSampler();

    public boolean scorching();

    public boolean natural();

    public double coordinateMultiplier();

    public boolean hasSkylight();

    public boolean hasCeiling();

    public float ambientLighting();

    public Optional<MinecraftDayTime> fixedTime();

    public boolean piglinSafe();

    public boolean bedsUsable();

    public boolean respawnAnchorsUsable();

    public boolean hasRaids();

    public int minY();

    public int logicalHeight();

    public int maximumHeight();

    public boolean createDragonFight();

    public static interface Factory {
        public WorldTypeTemplate overworld();

        public WorldTypeTemplate overworldCaves();

        public WorldTypeTemplate theNether();

        public WorldTypeTemplate theEnd();
    }

    public static interface Builder
    extends ResourceKeyedBuilder<WorldTypeTemplate, Builder>,
    CopyableBuilder<WorldTypeTemplate, Builder> {
        public Builder effect(WorldTypeEffect var1);

        public Builder biomeSampler(BiomeSampler var1);

        public Builder scorching(boolean var1);

        public Builder natural(boolean var1);

        public Builder coordinateMultiplier(double var1);

        public Builder hasSkylight(boolean var1);

        public Builder hasCeiling(boolean var1);

        public Builder ambientLighting(float var1);

        public Builder fixedTime(@Nullable MinecraftDayTime var1);

        public Builder piglinSafe(boolean var1);

        public Builder bedsUsable(boolean var1);

        public Builder respawnAnchorsUsable(boolean var1);

        public Builder hasRaids(boolean var1);

        public Builder minY(int var1);

        public Builder logicalHeight(int var1);

        public Builder maximumHeight(int var1);

        public Builder createDragonFight(boolean var1);
    }
}

