/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command;

import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.minecraft.commands.CommandSourceStack;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.command.Command;
import org.spongepowered.api.command.CommandCause;
import org.spongepowered.api.command.CommandCompletion;
import org.spongepowered.api.command.CommandExecutor;
import org.spongepowered.api.command.parameter.CommandContext;
import org.spongepowered.api.command.parameter.Parameter;
import org.spongepowered.api.command.parameter.managed.Flag;
import org.spongepowered.common.command.SpongeCommandCompletion;
import org.spongepowered.common.command.brigadier.SpongeParameterTranslator;
import org.spongepowered.common.command.brigadier.SpongeStringReader;
import org.spongepowered.common.command.brigadier.dispatcher.SpongeCommandDispatcher;
import org.spongepowered.common.command.manager.SpongeCommandManager;

public final class SpongeParameterizedCommand
implements Command.Parameterized {
    private final List<Parameter.Subcommand> subcommands;
    private final List<Parameter> parameters;
    private final List<Flag> flags;
    private final Function<CommandCause, Optional<Component>> shortDescription;
    private final Function<CommandCause, Optional<Component>> extendedDescription;
    private final Predicate<CommandCause> executionRequirements;
    private final @Nullable CommandExecutor executor;
    private final boolean isTerminal;
    private @Nullable SpongeCommandManager commandManager;
    private @Nullable SpongeCommandDispatcher cachedDispatcher;

    SpongeParameterizedCommand(List<Parameter.Subcommand> subcommands, List<Parameter> parameters, Function<CommandCause, Optional<Component>> shortDescription, Function<CommandCause, Optional<Component>> extendedDescription, Predicate<CommandCause> executionRequirements, @Nullable CommandExecutor executor, List<Flag> flags, boolean isTerminal) {
        this.subcommands = subcommands;
        this.parameters = parameters;
        this.shortDescription = shortDescription;
        this.extendedDescription = extendedDescription;
        this.executionRequirements = executionRequirements;
        this.executor = executor;
        this.flags = flags;
        this.isTerminal = isTerminal;
    }

    public void setCommandManager(SpongeCommandManager commandManager) {
        this.cachedDispatcher = null;
        this.commandManager = commandManager;
    }

    @Override
    public List<CommandCompletion> complete(@NonNull CommandCause cause,  @NonNull ArgumentReader.Mutable arguments) {
        SpongeCommandDispatcher dispatcher = this.getCachedDispatcher();
        String input = arguments.remaining();
        ParseResults<CommandSourceStack> parseResults = dispatcher.parse((StringReader)arguments, (CommandSourceStack)cause);
        Suggestions suggestions = (Suggestions)dispatcher.getCompletionSuggestions(parseResults).join();
        return suggestions.getList().stream().map(SpongeCommandCompletion::from).collect(Collectors.toList());
    }

    @Override
    public boolean canExecute(@NonNull CommandCause cause) {
        return this.executionRequirements().test(cause);
    }

    @Override
    public @NonNull Optional<Component> shortDescription(@NonNull CommandCause cause) {
        return this.shortDescription.apply(cause);
    }

    @Override
    public @NonNull Optional<Component> extendedDescription(@NonNull CommandCause cause) {
        return this.extendedDescription.apply(cause);
    }

    @Override
    public @NonNull Component usage(@NonNull CommandCause cause) {
        Collection usage = Arrays.stream(this.getCachedDispatcher().getAllUsage((CommandNode)this.getCachedDispatcher().getRoot(), (CommandSourceStack)cause, true)).map(Component::text).collect(Collectors.toList());
        return Component.join((ComponentLike)Component.newline(), (Iterable)usage);
    }

    @Override
    public List<Flag> flags() {
        return new ArrayList<Flag>(this.flags);
    }

    @Override
    public @NonNull List<Parameter> parameters() {
        return new ArrayList<Parameter>(this.parameters);
    }

    @Override
    public List<Parameter.Subcommand> subcommands() {
        return new ArrayList<Parameter.Subcommand>(this.subcommands);
    }

    @Override
    public boolean isTerminal() {
        return this.isTerminal;
    }

    @Override
    public @NonNull Predicate<CommandCause> executionRequirements() {
        return this.executionRequirements;
    }

    @Override
    public @NonNull CommandContext parseArguments(@NonNull CommandCause cause,  @NonNull ArgumentReader.Mutable arguments) {
        ParseResults<CommandSourceStack> results = this.getCachedDispatcher().parse((StringReader)((SpongeStringReader)arguments), (CommandSourceStack)cause);
        return (CommandContext)results.getContext().build(arguments.input());
    }

    @Override
    public Optional<CommandExecutor> executor() {
        return Optional.ofNullable(this.executor);
    }

    private SpongeCommandDispatcher getCachedDispatcher() {
        if (this.cachedDispatcher == null) {
            if (this.commandManager == null) {
                throw new IllegalStateException("Completions cannot be requested for an unregistered parameterized command");
            }
            this.cachedDispatcher = new SpongeCommandDispatcher(this.commandManager);
            this.cachedDispatcher.register(this.buildWithAlias("command"));
        }
        return this.cachedDispatcher;
    }

    public LiteralCommandNode<CommandSourceStack> buildWithAlias(String primaryAlias) {
        return this.buildWithAliases(Collections.singleton(primaryAlias)).iterator().next();
    }

    public Collection<LiteralCommandNode<CommandSourceStack>> buildWithAliases(Collection<String> aliases) {
        return SpongeParameterTranslator.INSTANCE.createCommandTree(this, aliases);
    }
}

