/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command.brigadier;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.command.Command;
import org.spongepowered.api.command.parameter.Parameter;
import org.spongepowered.api.command.parameter.managed.Flag;
import org.spongepowered.common.command.brigadier.argument.ArgumentParser;
import org.spongepowered.common.command.brigadier.argument.CustomArgumentParser;
import org.spongepowered.common.command.brigadier.tree.SpongeArgumentCommandNode;
import org.spongepowered.common.command.brigadier.tree.SpongeArgumentCommandNodeBuilder;
import org.spongepowered.common.command.brigadier.tree.SpongeCommandExecutorWrapper;
import org.spongepowered.common.command.brigadier.tree.SpongeFlagLiteralCommandNode;
import org.spongepowered.common.command.brigadier.tree.SpongeLiteralCommandNode;
import org.spongepowered.common.command.brigadier.tree.SpongeNode;
import org.spongepowered.common.command.parameter.SpongeParameterKey;
import org.spongepowered.common.command.parameter.SpongeParameterValue;
import org.spongepowered.common.command.parameter.multi.SpongeFirstOfParameter;
import org.spongepowered.common.command.parameter.multi.SpongeMultiParameter;

public final class SpongeParameterTranslator {
    public static final SpongeParameterTranslator INSTANCE = new SpongeParameterTranslator();

    private SpongeParameterTranslator() {
    }

    public Collection<LiteralCommandNode<CommandSourceStack>> createCommandTree(Command.Parameterized command, Collection<String> aliases) {
        if (aliases.isEmpty()) {
            throw new IllegalArgumentException("Aliases must not be empty.");
        }
        Collection sortedAliases = aliases.stream().sorted().collect(Collectors.toList());
        Iterator aliasIterator = sortedAliases.iterator();
        String baseAlias = (String)aliasIterator.next();
        SpongeCommandExecutorWrapper executor = command.executor().map(SpongeCommandExecutorWrapper::new).orElse(null);
        LiteralArgumentBuilder basicNode = LiteralArgumentBuilder.literal((String)baseAlias);
        basicNode.requires(command.executionRequirements());
        if (command.isTerminal() && executor != null) {
            basicNode.executes((Command)executor);
        }
        SpongeLiteralCommandNode commandNode = new SpongeLiteralCommandNode((LiteralArgumentBuilder<CommandSourceStack>)basicNode);
        if (executor != null) {
            this.createAndAttachNode(Collections.singleton(commandNode), command.parameters(), executor, true, true);
        }
        for (Parameter.Subcommand subcommand : command.subcommands()) {
            Collection<LiteralCommandNode<CommandSourceStack>> builtSubcommand = this.createCommandTree(subcommand.command(), subcommand.aliases());
            builtSubcommand.forEach(commandNode::addChild);
        }
        this.createFlags(commandNode, command.flags(), executor);
        ArrayList<SpongeLiteralCommandNode> allCommandNodes = new ArrayList<SpongeLiteralCommandNode>();
        allCommandNodes.add(commandNode);
        Collection children = commandNode.getChildren();
        while (aliasIterator.hasNext()) {
            LiteralArgumentBuilder redirectedNode = LiteralArgumentBuilder.literal((String)((String)aliasIterator.next()));
            redirectedNode.executes(commandNode.getCommand());
            redirectedNode.requires(commandNode.getRequirement());
            for (CommandNode child : children) {
                redirectedNode.then(child);
            }
            allCommandNodes.add(new SpongeLiteralCommandNode((LiteralArgumentBuilder<CommandSourceStack>)redirectedNode));
        }
        return Collections.unmodifiableCollection(allCommandNodes);
    }

    private void createFlags(LiteralCommandNode<CommandSourceStack> node, List<Flag> flags, @Nullable SpongeCommandExecutorWrapper wrapper) {
        ArrayList<CommandNode> nodesToAddChildrenTo = new ArrayList<CommandNode>();
        for (Flag flag : flags) {
            Iterator<String> aliasIterator = flag.aliases().iterator();
            LiteralArgumentBuilder flagLiteral = LiteralArgumentBuilder.literal((String)aliasIterator.next());
            flagLiteral.requires(flag.requirement());
            SpongeFlagLiteralCommandNode flagNode = new SpongeFlagLiteralCommandNode((LiteralArgumentBuilder<CommandSourceStack>)flagLiteral, flag);
            Collection<SpongeFlagLiteralCommandNode> toBeRedirected = flag.associatedParameter().isPresent() ? this.createAndAttachNode(Collections.singleton(flagNode), Collections.singletonList(flag.associatedParameter().get()), wrapper, node.getCommand() != null, false) : Collections.singletonList(flagNode);
            for (CommandNode commandNode : toBeRedirected) {
                if (commandNode instanceof SpongeNode && ((SpongeNode)commandNode).canForceRedirect()) {
                    ((SpongeNode)commandNode).forceRedirect((CommandNode<CommandSourceStack>)node);
                    continue;
                }
                nodesToAddChildrenTo.add(commandNode);
            }
            node.addChild((CommandNode)flagNode);
            while (aliasIterator.hasNext()) {
                LiteralArgumentBuilder nextFlag = (LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)aliasIterator.next()).executes(flagNode.getCommand());
                if (flagNode.getRedirect() != null) {
                    nextFlag.redirect(flagNode.getRedirect());
                } else {
                    nextFlag.redirect((CommandNode)flagNode);
                }
                node.addChild((CommandNode)new SpongeFlagLiteralCommandNode((LiteralArgumentBuilder<CommandSourceStack>)nextFlag, flag));
            }
        }
        if (!nodesToAddChildrenTo.isEmpty()) {
            for (CommandNode target : node.getChildren()) {
                if (!target.getChildren().isEmpty() && target instanceof SpongeFlagLiteralCommandNode) {
                    nodesToAddChildrenTo.forEach(x -> x.addChild((CommandNode)((SpongeFlagLiteralCommandNode)target).cloneWithRedirectToThis()));
                    continue;
                }
                nodesToAddChildrenTo.forEach(x -> x.addChild(target));
            }
        }
    }

    private Collection<? extends CommandNode<CommandSourceStack>> createAndAttachNode(Collection<? extends CommandNode<CommandSourceStack>> parents, List<Parameter> children, @Nullable SpongeCommandExecutorWrapper executorWrapper, boolean shouldTerminate, boolean allowSubcommands) {
        HashSet<? extends CommandNode<CommandSourceStack>> nodesToAttachTo = new HashSet<CommandNode<CommandSourceStack>>(parents);
        ListIterator<Parameter> parameterIterator = children.listIterator();
        while (parameterIterator.hasNext()) {
            ArrayList<Object> parametersToAttachTo;
            boolean isOptional;
            Parameter parameter = parameterIterator.next();
            boolean bl = parameterIterator.hasNext();
            if (parameter instanceof Parameter.Subcommand) {
                Parameter.Subcommand subcommands = (Parameter.Subcommand)parameter;
                if (!allowSubcommands) {
                    throw new IllegalStateException("Subcommands are not allowed for this element (subcommands were " + String.join((CharSequence)", ", subcommands.aliases() + ")!"));
                }
                if (bl) {
                    throw new IllegalStateException("A parameter cannot be placed after a subcommand parameter!");
                }
                Collection<LiteralCommandNode<CommandSourceStack>> nodes = this.createCommandTree(subcommands.command(), subcommands.aliases());
                for (LiteralCommandNode<CommandSourceStack> literalCommandNode : nodes) {
                    nodesToAttachTo.forEach(x -> x.addChild((CommandNode)node));
                }
                return Collections.emptyList();
            }
            if (parameter instanceof SpongeMultiParameter) {
                isOptional = parameter.isOptional();
                boolean bl2 = isTerminal = !bl || parameter.isTerminal();
                if (parameter instanceof SpongeFirstOfParameter) {
                    parametersToAttachTo = new ArrayList();
                    for (Parameter p : ((SpongeFirstOfParameter)parameter).childParameters()) {
                        Collection<? extends CommandNode<CommandSourceStack>> branchNodesToAttachTo = this.createAndAttachNode(nodesToAttachTo, Collections.singletonList(p), executorWrapper, isTerminal, allowSubcommands);
                        parametersToAttachTo.addAll(branchNodesToAttachTo);
                    }
                } else {
                    parametersToAttachTo = new ArrayList<CommandNode<CommandSourceStack>>(this.createAndAttachNode(nodesToAttachTo, ((SpongeMultiParameter)parameter).childParameters(), executorWrapper, isTerminal, allowSubcommands));
                }
            } else {
                parametersToAttachTo = new ArrayList();
                SpongeParameterValue spongeParameterValue = (SpongeParameterValue)parameter;
                boolean isConsumeAll = spongeParameterValue.willConsumeAllRemaining();
                if (isConsumeAll && bl) {
                    throw new IllegalStateException("A parameter that consumes all must be at the end of a parameter chain.");
                }
                isOptional = spongeParameterValue.isOptional();
                isTerminal = shouldTerminate && !bl || spongeParameterValue.isTerminal();
                StringBuilder suffix = null;
                Set names = nodesToAttachTo.stream().flatMap(x -> x.getChildren().stream()).map(CommandNode::getName).collect(Collectors.toSet());
                Object key = spongeParameterValue.key().key();
                while (names.contains(key)) {
                    if (suffix == null) {
                        suffix = new StringBuilder(String.valueOf(names.size()));
                    } else {
                        suffix.append("_").append(names.size());
                    }
                    key = (String)key + suffix;
                }
                SpongeArgumentCommandNodeBuilder thisNode = SpongeParameterTranslator.createArgumentNodeBuilders(spongeParameterValue, suffix == null ? null : suffix.toString());
                if (isTerminal) {
                    thisNode.executes(executorWrapper);
                }
                SpongeArgumentCommandNode builtNode = thisNode.build();
                if (isConsumeAll) {
                    builtNode.addChild((CommandNode)((SpongeArgumentCommandNodeBuilder)thisNode.redirect((CommandNode)builtNode)).build());
                }
                parametersToAttachTo.add(builtNode);
                nodesToAttachTo.forEach(x -> x.addChild(builtNode));
            }
            if (!isOptional) {
                nodesToAttachTo.clear();
            }
            nodesToAttachTo.addAll(parametersToAttachTo);
        }
        if (shouldTerminate) {
            for (CommandNode commandNode : nodesToAttachTo) {
                if (!(commandNode instanceof SpongeNode)) continue;
                ((SpongeNode)commandNode).forceExecutor(executorWrapper);
            }
        }
        return nodesToAttachTo;
    }

    private static <T> @NonNull SpongeArgumentCommandNodeBuilder<T> createArgumentNodeBuilders(SpongeParameterValue<T> parameter, @Nullable String suffix) {
        ArgumentParser<T> type = parameter.argumentTypeIfStandard();
        if (type == null) {
            type = new CustomArgumentParser<T>(parameter.parsers(), parameter.completer(), false);
        }
        SpongeArgumentCommandNodeBuilder<T> argumentBuilder = new SpongeArgumentCommandNodeBuilder<T>(SpongeParameterKey.getSpongeKey(parameter.key()), type, parameter.completer(), parameter.modifier().orElse(null), parameter.valueUsage().orElse(null), suffix);
        argumentBuilder.requires(parameter.requirement());
        return argumentBuilder;
    }
}

