/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command.brigadier.argument;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import org.spongepowered.api.command.exception.ArgumentParseException;
import org.spongepowered.api.command.parameter.CommandContext;
import org.spongepowered.api.command.parameter.Parameter;
import org.spongepowered.api.command.parameter.managed.ValueParameter;
import org.spongepowered.api.command.parameter.managed.ValueParameterModifier;
import org.spongepowered.common.command.brigadier.SpongeImmutableArgumentReader;
import org.spongepowered.common.command.brigadier.SpongeStringReader;
import org.spongepowered.common.command.brigadier.argument.ArgumentParser;
import org.spongepowered.common.command.brigadier.context.SpongeCommandContext;
import org.spongepowered.common.command.brigadier.context.SpongeCommandContextBuilder;
import org.spongepowered.common.util.CommandUtil;

public abstract class AbstractArgumentParser<T>
implements ArgumentParser<T>,
SuggestionProvider<CommandSourceStack>,
ValueParameter<T> {
    @Override
    public final T parse(Parameter.Key<? super T> key, SpongeCommandContextBuilder contextBuilder, SpongeStringReader reader, ValueParameterModifier<T> modifier) throws CommandSyntaxException {
        SpongeImmutableArgumentReader state = reader.immutable();
        CommandContext.Builder.Transaction transaction = contextBuilder.startTransaction();
        try {
            T value = this.modifyResult(key, contextBuilder, reader, modifier, this.parseValue(key, reader, contextBuilder).orElse(null));
            contextBuilder.commit(transaction);
            return value;
        }
        catch (ArgumentParseException e) {
            ArgumentParseException e2 = this.modifyExceptionMessage(reader, e, modifier);
            reader.setState(state);
            contextBuilder.rollback(transaction);
            throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherParseException().createWithContext((ImmutableStringReader)reader, (Object)e2);
        }
    }

    @Override
    public CompletableFuture<Suggestions> listSuggestions(CommandContext<?> context, SuggestionsBuilder builder) {
        List completions = this.complete((SpongeCommandContext)context, builder.getRemaining());
        return CommandUtil.buildSuggestionsFromCompletions(completions, builder);
    }

    @Override
    public Collection<String> getExamples() {
        return Collections.emptyList();
    }

    public CompletableFuture<Suggestions> getSuggestions(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        return this.listSuggestions(context, builder);
    }

    @Override
    public boolean doesNotRead() {
        return false;
    }
}

