/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command.brigadier.argument;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.command.exception.ArgumentParseException;
import org.spongepowered.api.command.parameter.Parameter;
import org.spongepowered.api.command.parameter.managed.ValueParameterModifier;
import org.spongepowered.common.command.brigadier.SpongeStringReader;
import org.spongepowered.common.command.brigadier.context.SpongeCommandContextBuilder;
import org.spongepowered.common.util.Constants;

public interface ArgumentParser<T> {
    public T parse(Parameter.Key<? super T> var1, SpongeCommandContextBuilder var2, SpongeStringReader var3, @Nullable ValueParameterModifier<T> var4) throws CommandSyntaxException;

    public CompletableFuture<Suggestions> listSuggestions(CommandContext<?> var1, SuggestionsBuilder var2);

    public Collection<String> getExamples();

    default public List<ArgumentType<?>> getClientCompletionArgumentType() {
        return Collections.singletonList(Constants.Command.STANDARD_STRING_ARGUMENT_TYPE);
    }

    default public T modifyResult(Parameter.Key<? super T> key, SpongeCommandContextBuilder contextBuilder, SpongeStringReader reader, @Nullable ValueParameterModifier<T> modifier, @Nullable T value) throws ArgumentParseException {
        if (modifier != null) {
            return modifier.modifyResult(key, reader.immutable(), contextBuilder, (T)value).orElse(null);
        }
        return value;
    }

    default public ArgumentParseException modifyExceptionMessage(SpongeStringReader reader, ArgumentParseException thrownException, @Nullable ValueParameterModifier<T> modifier) {
        Component replacementMessage;
        if (modifier != null && (replacementMessage = modifier.modifyExceptionMessage(thrownException.superText())) != thrownException.superText()) {
            return reader.createException(replacementMessage);
        }
        return thrownException;
    }

    public boolean doesNotRead();

    default public boolean hasClientNativeCompletions() {
        return false;
    }
}

