/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.world.Archetype;
import org.spongepowered.api.world.LocatableSnapshot;
import org.spongepowered.common.data.holder.SpongeMutableDataHolder;
import org.spongepowered.common.data.nbt.validation.DelegateDataValidator;
import org.spongepowered.common.data.nbt.validation.RawDataValidator;
import org.spongepowered.common.data.nbt.validation.ValidationType;
import org.spongepowered.common.data.persistence.NBTTranslator;
import org.spongepowered.common.data.provider.DataProviderLookup;

public abstract class AbstractArchetype<T, S extends LocatableSnapshot<S>, E>
implements Archetype<S, E>,
SpongeMutableDataHolder {
    protected final T type;
    protected CompoundTag compound;

    protected AbstractArchetype(T type, CompoundTag compound) {
        this.type = type;
        this.compound = compound;
    }

    public abstract DataProviderLookup getLookup();

    protected abstract ValidationType getValidationType();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractArchetype)) {
            return false;
        }
        AbstractArchetype that = (AbstractArchetype)o;
        return this.type.equals(that.type) && this.compound.equals((Object)that.compound);
    }

    @Override
    public void setRawData(DataView container) throws InvalidDataException {
        Preconditions.checkNotNull((Object)container, (Object)"Raw data cannot be null!");
        CompoundTag copy = NBTTranslator.INSTANCE.translate(container);
        boolean valid = this.getValidator().validate(copy);
        if (!valid) {
            throw new InvalidDataException("Invalid data for " + this.getValidationType());
        }
        this.compound = copy;
    }

    @Override
    public boolean validateRawData(DataView container) {
        return this.getValidator().validate(container);
    }

    private DelegateDataValidator getValidator() {
        return new DelegateDataValidator(this.getValidators(), this.getValidationType());
    }

    protected abstract ImmutableList<RawDataValidator> getValidators();

    public int hashCode() {
        return Objects.hash(this.type, this.compound);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", this.type).add("data", (Object)this.compound).toString();
    }

    public CompoundTag getCompound() {
        return this.compound;
    }
}

